/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.daw.midi;

public class DeviceInquiry {
    private static final int LENGTH_RESULT_SHORT = 15;
    private static final int LENGTH_RESULT_LONG = 17;
    private static final int LENGTH_DEVICE_FAMILY = 4;
    private static final int LENGTH_SOFTWARE_REVISION = 4;
    private static final int OFFSET_DEVICE_ID = 2;
    private static final int OFFSET_MANUFACTURER_ID = 5;
    private static final int OFFSET_CONTENT_SHORT = 6;
    private static final int OFFSET_CONTENT_LONG = 8;
    private static final byte[] INQUIRY = new byte[]{-16, 126, 127, 6, 1, -9};
    private final int[] data;
    private ResponseType responseType;

    public DeviceInquiry(int[] data) {
        this.data = data;
        if (data.length == 15) {
            this.responseType = ResponseType.SHORT;
        } else if (data.length == 17) {
            this.responseType = ResponseType.LONG;
        } else if (data.length > 17) {
            this.responseType = ResponseType.NOT_IN_SPEC;
        } else {
            this.responseType = ResponseType.ERROR;
            return;
        }
        if (data[0] != 240 || data[1] != 126 || data[3] != 6 || data[4] != 2 || data[data.length - 1] != 247) {
            this.responseType = ResponseType.ERROR;
        }
    }

    public boolean isValid() {
        return this.responseType != ResponseType.ERROR;
    }

    public int getDeviceID() {
        return this.isValid() ? this.data[2] : -1;
    }

    public int[] getManufacturer() {
        if (!this.isValid()) {
            return new int[0];
        }
        if (this.responseType == ResponseType.SHORT) {
            return new int[]{this.data[5]};
        }
        return new int[]{this.data[5], this.data[6], this.data[7]};
    }

    public int[] getDeviceFamilyCode() {
        if (!this.isValid()) {
            return new int[0];
        }
        int contentStart = this.getContentStart();
        return new int[]{this.data[contentStart], this.data[contentStart + 1]};
    }

    public int[] getDeviceFamilyMemberCode() {
        if (!this.isValid()) {
            return new int[0];
        }
        int contentStart = this.getContentStart();
        return new int[]{this.data[contentStart + 2], this.data[contentStart + 3]};
    }

    public int[] getRevisionLevel() {
        if (!this.isValid()) {
            return new int[0];
        }
        int start = this.getContentStart() + 4;
        int[] softwareData = new int[4];
        System.arraycopy(this.data, start, softwareData, 0, 4);
        return softwareData;
    }

    public int[] getUnspecifiedData() {
        if (!this.isValid()) {
            return new int[0];
        }
        int contentStart = this.getContentStart();
        int length = this.data.length - contentStart - 4 - 1;
        int start = contentStart + 4;
        int[] softwareData = new int[length];
        System.arraycopy(this.data, start, softwareData, 0, length);
        return softwareData;
    }

    public static byte[] createQuery() {
        return INQUIRY;
    }

    private int getContentStart() {
        return this.responseType == ResponseType.SHORT ? 6 : 8;
    }

    public int[] getData() {
        return this.data;
    }

    private static enum ResponseType {
        SHORT,
        LONG,
        NOT_IN_SPEC,
        ERROR;

    }
}

