/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.daw;

import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.data.IBrowserColumn;
import de.mossgrabers.framework.daw.data.IBrowserColumnItem;
import de.mossgrabers.framework.observer.IValueObserver;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractBrowser
implements IBrowser {
    protected static final String INSERT_DEVICE_BEFORE = "Insert device before: ";
    protected static final String INSERT_DEVICE_AFTER = "Insert device after: ";
    protected final int numResults;
    protected final int numFilterColumnEntries;
    protected IBrowserColumnItem[] resultData;
    protected IBrowserColumn[] columnData;
    protected int selectedFilterColumn = 0;
    protected String infoText = "";
    private final List<IValueObserver<Boolean>> activeObservers = new ArrayList<IValueObserver<Boolean>>();

    protected AbstractBrowser(int numFilterColumnEntries, int numResults) {
        this.numFilterColumnEntries = numFilterColumnEntries;
        this.numResults = numResults;
    }

    @Override
    public void addActiveObserver(IValueObserver<Boolean> activeObserver) {
        this.activeObservers.add(activeObserver);
    }

    @Override
    public boolean hasPreviousContentType() {
        return this.getSelectedContentTypeIndex() > 0;
    }

    @Override
    public boolean hasNextContentType() {
        return this.getSelectedContentTypeIndex() < this.getContentTypeNames().length - 1;
    }

    @Override
    public void resetFilterColumn(int column) {
        this.columnData[column].resetFilter();
    }

    @Override
    public IBrowserColumn getFilterColumn(int column) {
        return this.columnData[column];
    }

    @Override
    public int getFilterColumnCount() {
        return this.columnData.length;
    }

    @Override
    public String[] getFilterColumnNames() {
        String[] names = new String[this.columnData.length];
        for (int i = 0; i < this.columnData.length; ++i) {
            names[i] = this.columnData[i].getName();
        }
        return names;
    }

    @Override
    public IBrowserColumnItem[] getResultColumnItems() {
        return this.resultData;
    }

    @Override
    public void selectPreviousFilterItem(int columnIndex) {
        if (columnIndex >= 0) {
            this.columnData[columnIndex].selectPreviousItem();
        }
    }

    @Override
    public IBrowserColumn getSelectedFilterColumn() {
        return this.columnData[this.selectedFilterColumn];
    }

    @Override
    public void selectPreviousFilterColumn() {
        if (this.selectedFilterColumn > 0) {
            --this.selectedFilterColumn;
        }
    }

    @Override
    public void selectNextFilterColumn() {
        if (this.selectedFilterColumn < this.columnData.length - 1) {
            ++this.selectedFilterColumn;
        }
    }

    @Override
    public void selectNextFilterItem(int columnIndex) {
        if (columnIndex >= 0) {
            this.columnData[columnIndex].selectNextItem();
        }
    }

    @Override
    public void previousFilterItemPage(int columnIndex) {
        if (columnIndex >= 0) {
            this.columnData[columnIndex].scrollItemPageUp();
        }
    }

    @Override
    public void nextFilterItemPage(int columnIndex) {
        if (columnIndex >= 0) {
            this.columnData[columnIndex].scrollItemPageDown();
        }
    }

    @Override
    public int getSelectedFilterItemIndex(int columnIndex) {
        if (columnIndex < 0) {
            return -1;
        }
        return this.columnData[columnIndex].getCursorIndex();
    }

    public void setSelectedFilterItemIndex(int columnIndex, int index) {
        if (columnIndex >= 0) {
            this.columnData[columnIndex].setCursorIndex(index);
        }
    }

    public int getSelectedResultIndex() {
        for (int i = 0; i < this.numResults; ++i) {
            if (!this.resultData[i].isSelected()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getNumResults() {
        return this.numResults;
    }

    @Override
    public int getNumFilterColumnEntries() {
        return this.numFilterColumnEntries;
    }

    @Override
    public String getInfoText() {
        return this.infoText;
    }

    protected void fireActiveObserver(boolean isActive) {
        Boolean isActiveObject = isActive;
        this.activeObservers.forEach(observer -> observer.update(isActiveObject));
    }
}

