/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.device;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.ILayer;
import de.mossgrabers.framework.daw.data.bank.ILayerBank;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.Optional;

public class DeviceLayerLeftCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    public DeviceLayerLeftCommand(IModel model, S surface) {
        super(model, surface);
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ICursorDevice cd = this.model.getCursorDevice();
        ILayerBank bank = cd.getLayerBank();
        if (!cd.hasLayers() || bank.getSelectedItem().isEmpty()) {
            cd.selectPrevious();
        } else {
            bank.selectPreviousItem();
        }
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ICursorDevice cd = this.model.getCursorDevice();
        ILayerBank bank = cd.getLayerBank();
        Optional layer = bank.getSelectedItem();
        if (!cd.hasLayers() || layer.isEmpty()) {
            if (cd.isNested()) {
                cd.selectParent();
                cd.selectChannel();
            }
        } else {
            ((ILayer)layer.get()).setSelected(false);
        }
    }

    public boolean canExecute() {
        if (this.surface.isShiftPressed()) {
            return true;
        }
        ICursorDevice cd = this.model.getCursorDevice();
        ILayerBank bank = cd.getLayerBank();
        Optional layer = bank.getSelectedItem();
        return cd.hasLayers() && layer.isPresent() ? bank.canScrollBackwards() : cd.canSelectPrevious();
    }
}

