/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;

public class MarkerCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    public MarkerCommand(IModel model, S surface) {
        super(model, surface);
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (this.surface.isSelectPressed()) {
            this.model.getMarkerBank().addMarker();
            return;
        }
        ModeManager modeManager = this.surface.getModeManager();
        if (modeManager.isActive(new Modes[]{Modes.MARKERS})) {
            modeManager.restore();
        } else {
            modeManager.setActive(Modes.MARKERS);
        }
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            this.model.getArranger().toggleCueMarkerVisibility();
        }
    }
}

