/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.slmkiii.mode.device;

import de.mossgrabers.controller.novation.slmkiii.SLMkIIIConfiguration;
import de.mossgrabers.controller.novation.slmkiii.controller.SLMkIIIControlSurface;
import de.mossgrabers.controller.novation.slmkiii.controller.SLMkIIIDisplay;
import de.mossgrabers.controller.novation.slmkiii.mode.device.AbstractParametersMode;
import de.mossgrabers.framework.command.trigger.BrowserCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.IDevice;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.daw.data.ISpecificDevice;
import de.mossgrabers.framework.daw.data.bank.IDeviceBank;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.bank.IParameterPageBank;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.device.BankParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.ResetParameterProvider;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;

public class ParametersMode
extends AbstractParametersMode<IItem> {
    private boolean showDevices;
    private final BrowserCommand<SLMkIIIControlSurface, SLMkIIIConfiguration> browserCommand;
    private final ISpecificDevice device;
    private final int color;
    private final int halfColor;

    public ParametersMode(SLMkIIIControlSurface surface, IModel model, String deviceName, ISpecificDevice device, int color, int halfColor) {
        super(deviceName + " Parameters", surface, model, null);
        this.device = device;
        this.color = color;
        this.halfColor = halfColor;
        this.setShowDevices(true);
        this.browserCommand = new BrowserCommand(model, surface);
        BankParameterProvider parameterProvider = new BankParameterProvider(device.getParameterBank());
        this.setParameterProvider(parameterProvider);
        this.setParameterProvider(ButtonID.DELETE, new ResetParameterProvider(parameterProvider));
    }

    public final void setShowDevices(boolean showDevices) {
        ISpecificDevice iSpecificDevice = this.device;
        if (iSpecificDevice instanceof ICursorDevice) {
            ICursorDevice cursorDevice = (ICursorDevice)iSpecificDevice;
            this.showDevices = showDevices;
            this.switchBanks(this.showDevices ? cursorDevice.getDeviceBank() : this.device.getParameterBank());
        }
    }

    public boolean isShowDevices() {
        return this.showDevices;
    }

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        if (((SLMkIIIControlSurface)this.surface).isShiftPressed()) {
            this.onButtonShifted(index);
            return;
        }
        if (((SLMkIIIControlSurface)this.surface).isLongPressed(ButtonID.ARROW_UP)) {
            this.onButtonArrowUp(index);
            return;
        }
        if (!this.device.doesExist()) {
            return;
        }
        if (!this.showDevices) {
            IParameterPageBank parameterPageBank = this.device.getParameterBank().getPageBank();
            if (parameterPageBank.getSelectedItemIndex() == index) {
                this.setShowDevices(!this.isShowDevices());
            } else {
                parameterPageBank.selectPage(index);
            }
            return;
        }
        if (((SLMkIIIControlSurface)this.surface).isPressed(ButtonID.DUPLICATE)) {
            ((SLMkIIIControlSurface)this.surface).setTriggerConsumed(ButtonID.DUPLICATE);
            this.device.duplicate();
            return;
        }
        if (((SLMkIIIControlSurface)this.surface).isPressed(ButtonID.DELETE)) {
            ((SLMkIIIControlSurface)this.surface).setTriggerConsumed(ButtonID.DELETE);
            ISpecificDevice iSpecificDevice = this.device;
            if (iSpecificDevice instanceof ICursorDevice) {
                ICursorDevice cursorDevice = (ICursorDevice)iSpecificDevice;
                ((IDevice)cursorDevice.getDeviceBank().getItem(index)).remove();
            }
            return;
        }
        if (this.device.getIndex() == index) {
            this.setShowDevices(!this.isShowDevices());
        } else {
            ISpecificDevice iSpecificDevice = this.device;
            if (iSpecificDevice instanceof ICursorDevice) {
                ICursorDevice cursorDevice = (ICursorDevice)iSpecificDevice;
                ((IDevice)cursorDevice.getDeviceBank().getItem(index)).select();
            }
        }
    }

    private void onButtonShifted(int index) {
        switch (index) {
            case 0: {
                if (!this.device.doesExist()) break;
                this.device.toggleEnabledState();
                break;
            }
            case 1: {
                if (!this.device.doesExist()) break;
                this.device.toggleParameterPageSectionVisible();
                break;
            }
            case 2: {
                if (!this.device.doesExist()) break;
                this.device.toggleExpanded();
                break;
            }
            case 3: {
                if (!this.device.doesExist()) break;
                this.device.toggleWindowOpen();
                break;
            }
            case 4: {
                ISpecificDevice iSpecificDevice;
                if (!this.device.doesExist() || !((iSpecificDevice = this.device) instanceof ICursorDevice)) break;
                ICursorDevice cursorDevice = (ICursorDevice)iSpecificDevice;
                cursorDevice.togglePinned();
                break;
            }
            case 5: {
                if (!this.device.doesExist()) break;
                this.browserCommand.startBrowser(true, true);
                break;
            }
            case 6: {
                if (!this.device.doesExist()) break;
                this.browserCommand.startBrowser(false, false);
                break;
            }
            case 7: {
                if (!this.model.getCursorTrack().doesExist()) break;
                this.browserCommand.startBrowser(true, false);
                break;
            }
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        ISpecificDevice iSpecificDevice;
        if (((SLMkIIIControlSurface)this.surface).isShiftPressed()) {
            return this.getButtonColorShifted(buttonID);
        }
        if (((SLMkIIIControlSurface)this.surface).isLongPressed(ButtonID.ARROW_UP)) {
            return this.getButtonColorArrowUp(buttonID);
        }
        if (!this.device.doesExist()) {
            return 0;
        }
        int index = buttonID.ordinal() - ButtonID.ROW1_1.ordinal();
        if (this.showDevices && (iSpecificDevice = this.device) instanceof ICursorDevice) {
            ICursorDevice cursorDevice = (ICursorDevice)iSpecificDevice;
            IDeviceBank bank = cursorDevice.getDeviceBank();
            IDevice item = (IDevice)bank.getItem(index);
            if (!item.doesExist()) {
                return 0;
            }
            return index == this.device.getIndex() ? 29 : 31;
        }
        IParameterPageBank bank = this.device.getParameterBank().getPageBank();
        int selectedItemIndex = bank.getSelectedItemIndex();
        if (((String)bank.getItem(index)).isEmpty()) {
            return 0;
        }
        return index == selectedItemIndex ? this.color : this.halfColor;
    }

    private int getButtonColorShifted(ButtonID buttonID) {
        if (!this.device.doesExist()) {
            if (buttonID == ButtonID.ROW1_8 && this.model.getCursorTrack().doesExist()) {
                return 7;
            }
            return 0;
        }
        switch (buttonID) {
            case ROW1_1: {
                return this.device.isEnabled() ? 5 : 7;
            }
            case ROW1_2: {
                return this.device.isParameterPageSectionVisible() ? 5 : 7;
            }
            case ROW1_3: {
                return this.device.isExpanded() ? 5 : 7;
            }
            case ROW1_4: {
                return this.device.isWindowOpen() ? 5 : 7;
            }
            case ROW1_5: {
                ICursorDevice cursorDevice;
                ISpecificDevice iSpecificDevice = this.device;
                return iSpecificDevice instanceof ICursorDevice && (cursorDevice = (ICursorDevice)iSpecificDevice).isPinned() ? 5 : 7;
            }
        }
        return 7;
    }

    @Override
    public void updateDisplay() {
        SLMkIIIDisplay d = ((SLMkIIIControlSurface)this.surface).getDisplay();
        d.clear();
        if (!this.device.doesExist()) {
            d.setBlock(1, 1, " Please  select or").setBlock(1, 2, "add a    device.");
            d.setCell(0, 8, this.model.getCursorTrack().getName(8)).setCell(1, 8, "No device");
            d.hideAllElements();
            this.drawRow4(d, null);
        } else {
            IParameterBank parameterBank = this.device.getParameterBank();
            IParameterPageBank parameterPageBank = parameterBank.getPageBank();
            d.setCell(0, 8, this.model.getCursorTrack().getName(8)).setCell(1, 8, this.device.getName(9));
            for (int i = 0; i < 8; ++i) {
                IParameter param = (IParameter)parameterBank.getItem(i);
                d.setCell(0, i, param.doesExist() ? StringUtils.fixASCII(param.getName(9)) : "").setCell(1, i, StringUtils.fixASCII(param.getDisplayedValue(9)));
                int c = param.doesExist() ? this.color : 0;
                d.setPropertyColor(i, 0, c);
                d.setPropertyColor(i, 1, c);
            }
            this.drawRow4(d, parameterPageBank);
        }
        this.setButtonInfo(d);
        d.allDone();
    }

    private void drawRow4(SLMkIIIDisplay d, IParameterPageBank parameterPageBank) {
        ISpecificDevice iSpecificDevice;
        if (((SLMkIIIControlSurface)this.surface).isShiftPressed()) {
            this.drawRow4Shifted(d);
            return;
        }
        if (((SLMkIIIControlSurface)this.surface).isLongPressed(ButtonID.ARROW_UP)) {
            this.drawRow4ArrowUp(d);
            return;
        }
        if (!this.device.doesExist()) {
            for (int i = 0; i < 8; ++i) {
                d.setPropertyColor(i, 2, 0);
                d.setPropertyValue(i, 1, 0);
            }
            return;
        }
        if (this.showDevices && (iSpecificDevice = this.device) instanceof ICursorDevice) {
            ICursorDevice cursorDevice = (ICursorDevice)iSpecificDevice;
            IDeviceBank deviceBank = cursorDevice.getDeviceBank();
            for (int i = 0; i < 8; ++i) {
                IDevice device = (IDevice)deviceBank.getItem(i);
                StringBuilder sb = new StringBuilder();
                if (device.doesExist()) {
                    sb.append(device.getName(9));
                }
                d.setCell(3, i, sb.toString());
                d.setPropertyColor(i, 2, device.doesExist() ? 29 : 0);
                d.setPropertyValue(i, 1, device.doesExist() && i == cursorDevice.getIndex() ? 1 : 0);
            }
        } else {
            for (int i = 0; i < parameterPageBank.getPageSize(); ++i) {
                String item = (String)parameterPageBank.getItem(i);
                d.setCell(3, i, item.isEmpty() ? "" : item);
                d.setPropertyColor(i, 2, item.isEmpty() ? 0 : this.color);
                d.setPropertyValue(i, 1, parameterPageBank.getSelectedItemIndex() == i ? 1 : 0);
            }
        }
    }

    private void drawRow4Shifted(SLMkIIIDisplay d) {
        if (this.device.doesExist()) {
            ICursorDevice cursorDevice;
            d.setCell(3, 0, "On/Off");
            d.setPropertyColor(0, 2, 5);
            d.setPropertyValue(0, 1, this.device.isEnabled() ? 1 : 0);
            d.setCell(3, 1, "Params");
            d.setPropertyColor(1, 2, 5);
            d.setPropertyValue(1, 1, this.device.isParameterPageSectionVisible() ? 1 : 0);
            d.setCell(3, 2, "Expanded");
            d.setPropertyColor(2, 2, 5);
            d.setPropertyValue(2, 1, this.device.isExpanded() ? 1 : 0);
            d.setCell(3, 3, "Window");
            d.setPropertyColor(3, 2, 5);
            d.setPropertyValue(3, 1, this.device.isWindowOpen() ? 1 : 0);
            d.setCell(3, 4, "Pin");
            d.setPropertyColor(4, 2, 5);
            ISpecificDevice iSpecificDevice = this.device;
            d.setPropertyValue(4, 1, iSpecificDevice instanceof ICursorDevice && (cursorDevice = (ICursorDevice)iSpecificDevice).isPinned() ? 1 : 0);
            d.setCell(3, 5, "<< Insert");
            d.setPropertyColor(5, 2, 5);
            d.setPropertyValue(5, 1, 0);
            d.setCell(3, 6, "Replace");
            d.setPropertyColor(6, 2, 5);
            d.setPropertyValue(6, 1, 0);
        } else {
            for (int i = 0; i < 7; ++i) {
                d.setPropertyColor(i, 2, 0);
                d.setPropertyValue(i, 1, 0);
            }
        }
        if (this.model.getCursorTrack().doesExist()) {
            d.setCell(3, 7, "Insert >>");
            d.setPropertyColor(7, 2, 5);
            d.setPropertyValue(7, 1, 0);
        }
    }

    @Override
    public int getModeColor() {
        return this.color;
    }
}

