/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.view;

import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.controller.novation.launchpad.view.AbstractFaderView;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.grid.IVirtualFader;
import de.mossgrabers.framework.controller.grid.IVirtualFaderCallback;
import de.mossgrabers.framework.controller.grid.VirtualFaderImpl;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.ScrollStates;
import java.util.Optional;

public class VolumeView
extends AbstractFaderView
implements IVirtualFaderCallback {
    private final IVirtualFader masterFader;

    public VolumeView(LaunchpadControlSurface surface, IModel model) {
        super("Volume", surface, model);
        this.masterFader = new VirtualFaderImpl(model.getHost(), this);
    }

    @Override
    public void onValueKnob(int index, int value) {
        ((ITrack)this.model.getCurrentTrackBank().getItem(index)).setVolume(value);
    }

    @Override
    protected int getFaderValue(int index) {
        return ((ITrack)this.model.getCurrentTrackBank().getItem(index)).getVolume();
    }

    @Override
    public void drawGrid() {
        for (int i = 0; i < 8; ++i) {
            this.setupFader(i);
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        IMasterTrack track = this.model.getMasterTrack();
        int color = track.doesExist() ? this.colorManager.getColorIndex(DAWColor.getColorID(track.getColor())) : 0;
        this.masterFader.setup(color, false);
        this.masterFader.setValue(track.getVolume());
        int index = 7 - (buttonID.ordinal() - ButtonID.SCENE1.ordinal());
        return this.masterFader.getColorState(index);
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (!ButtonID.isSceneButton(buttonID) || event != ButtonEvent.DOWN) {
            return;
        }
        int index = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
        this.masterFader.moveTo(7 - index, velocity);
    }

    @Override
    public void setupFader(int index) {
        ITrack track = (ITrack)this.model.getCurrentTrackBank().getItem(index);
        int color = this.colorManager.getColorIndex(DAWColor.getColorID(track.getColor()));
        ((LaunchpadControlSurface)this.surface).setupFader(index, color, false);
        ((LaunchpadControlSurface)this.surface).setFaderValue(index, track.getVolume());
    }

    @Override
    public int getValue() {
        return this.model.getMasterTrack().getVolume();
    }

    @Override
    public void setValue(int value) {
        this.model.getMasterTrack().setVolume(value);
    }

    @Override
    public void updateScrollStates(ScrollStates scrollStates) {
        ITrackBank tb = this.model.getCurrentTrackBank();
        Optional sel = tb.getSelectedItem();
        int selIndex = sel.isPresent() ? ((ITrack)sel.get()).getIndex() : -1;
        ISceneBank sceneBank = tb.getSceneBank();
        scrollStates.setCanScrollLeft(selIndex > 0 || tb.canScrollPageBackwards());
        scrollStates.setCanScrollRight(selIndex >= 0 && selIndex < 7 && ((ITrack)tb.getItem(selIndex + 1)).doesExist() || tb.canScrollPageForwards());
        scrollStates.setCanScrollUp(sceneBank.canScrollPageBackwards());
        scrollStates.setCanScrollDown(sceneBank.canScrollPageForwards());
    }
}

