/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.view;

import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadColorManager;
import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.controller.novation.launchpad.view.AbstractFaderView;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.Capability;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.ScrollStates;

public class DeviceView
extends AbstractFaderView {
    private final ICursorDevice cursorDevice;

    public DeviceView(LaunchpadControlSurface surface, IModel model) {
        super("Device", surface, model);
        this.cursorDevice = this.model.getCursorDevice();
    }

    @Override
    public void setupFader(int index) {
        ((LaunchpadControlSurface)this.surface).setupFader(index, LaunchpadColorManager.DAW_INDICATOR_COLORS.get(index), false);
        this.onValueKnob(index, this.getFaderValue(index));
    }

    @Override
    public void onValueKnob(int index, int value) {
        ((IParameter)this.cursorDevice.getParameterBank().getItem(index)).setValueImmediatly(value);
    }

    @Override
    protected int getFaderValue(int index) {
        return ((IParameter)this.cursorDevice.getParameterBank().getItem(index)).getValue();
    }

    @Override
    public void drawGrid() {
        IParameterBank parameterBank = this.cursorDevice.getParameterBank();
        for (int i = 0; i < 8; ++i) {
            ((LaunchpadControlSurface)this.surface).setFaderValue(i, ((IParameter)parameterBank.getItem(i)).getValue());
        }
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        switch (buttonID) {
            case SCENE1: {
                this.cursorDevice.toggleEnabledState();
                break;
            }
            case SCENE2: {
                this.cursorDevice.toggleWindowOpen();
                break;
            }
            case SCENE3: {
                this.cursorDevice.toggleParameterPageSectionVisible();
                break;
            }
            case SCENE4: {
                this.cursorDevice.toggleExpanded();
                break;
            }
            case SCENE5: {
                boolean isPinned = !this.cursorDevice.isPinned();
                this.cursorDevice.setPinned(isPinned);
                this.model.getCursorTrack().setPinned(isPinned);
                this.mvHelper.delayDisplay(() -> this.cursorDevice.getName() + ": " + (this.cursorDevice.isPinned() ? "Pinned" : "Not pinned"));
                break;
            }
            case SCENE6: {
                break;
            }
            case SCENE7: {
                break;
            }
            case SCENE8: {
                IBrowser browser = this.model.getBrowser();
                if (!this.cursorDevice.doesExist()) {
                    browser.insertAfterCursorDevice();
                    break;
                }
                browser.replace(this.cursorDevice);
                break;
            }
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        switch (buttonID) {
            case SCENE1: {
                return this.cursorDevice.isEnabled() ? 21 : 1;
            }
            case SCENE2: {
                return this.cursorDevice.isWindowOpen() ? 9 : 11;
            }
            case SCENE3: {
                if (!this.model.getHost().supports(Capability.HAS_PARAMETER_PAGE_SECTION)) {
                    return 0;
                }
                return this.cursorDevice.isParameterPageSectionVisible() ? 57 : 59;
            }
            case SCENE4: {
                return this.cursorDevice.isExpanded() ? 53 : 55;
            }
            case SCENE5: {
                if (!this.model.getHost().supports(Capability.HAS_PINNING)) {
                    return 0;
                }
                return this.cursorDevice.isPinned() ? 29 : 31;
            }
            case SCENE8: {
                return 14;
            }
        }
        return 0;
    }

    @Override
    public void updateScrollStates(ScrollStates scrollStates) {
        IParameterBank parameterBank = this.cursorDevice.getParameterBank();
        scrollStates.setCanScrollLeft(parameterBank.canScrollPageBackwards());
        scrollStates.setCanScrollRight(parameterBank.canScrollPageForwards());
        scrollStates.setCanScrollUp(this.cursorDevice.canSelectPrevious());
        scrollStates.setCanScrollDown(this.cursorDevice.canSelectNext());
    }
}

