/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchcontrol.mode.main;

import de.mossgrabers.controller.novation.launchcontrol.controller.LaunchControlXLControlSurface;
import de.mossgrabers.controller.novation.launchcontrol.mode.main.XLAbstractTrackMode;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.DeviceID;
import de.mossgrabers.framework.daw.data.IEqualizerDevice;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.device.BankParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.CombinedParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.FixedParameterProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class XLEqMode
extends XLAbstractTrackMode {
    private final IEqualizerDevice eqDevice;

    public XLEqMode(LaunchControlXLControlSurface surface, IModel model, List<ContinuousID> controls) {
        super("Equalizer", surface, model, controls);
        this.eqDevice = (IEqualizerDevice)model.getSpecificDevice(DeviceID.EQ);
        ArrayList<IParameter> eqParameters = new ArrayList<IParameter>(16);
        eqParameters.addAll(this.eqDevice.getTypeParameters());
        eqParameters.addAll(this.eqDevice.getQParameters());
        List<IParameter> frequencyParameters = this.eqDevice.getFrequencyParameters();
        FixedParameterProvider eqParameterProvider = new FixedParameterProvider(eqParameters);
        FixedParameterProvider frequencyParameterProvider = new FixedParameterProvider(frequencyParameters);
        BankParameterProvider deviceParameterProvider = new BankParameterProvider(this.model.getCursorDevice().getParameterBank());
        this.setParameterProviders(new CombinedParameterProvider(eqParameterProvider, frequencyParameterProvider), new CombinedParameterProvider(eqParameterProvider, deviceParameterProvider));
        this.model.getTrackBank().addSelectionObserver(this::trackSelectionChanged);
        ITrackBank effectTrackBank = this.model.getEffectTrackBank();
        if (effectTrackBank != null) {
            effectTrackBank.addSelectionObserver(this::trackSelectionChanged);
        }
    }

    @Override
    public int getKnobValue(int index) {
        int row = index / 8;
        int column = index % 8;
        switch (row) {
            case 0: {
                return this.eqDevice.getTypeParameter(column).getValue();
            }
            case 1: {
                return this.eqDevice.getQParameter(column).getValue();
            }
            case 2: {
                if (this.configuration.isDeviceActive()) {
                    return ((IParameter)this.model.getCursorDevice().getParameterBank().getItem(column)).getValue();
                }
                return this.eqDevice.getFrequencyParameter(column).getValue();
            }
        }
        return 0;
    }

    @Override
    public void setKnobColor(int row, int column, int value) {
        int green = 0;
        int red = 0;
        block0 : switch (row) {
            case 0: {
                switch (this.eqDevice.getTypeID(column)) {
                    case BELL: {
                        green = 3;
                        break block0;
                    }
                    case HIGHCUT: {
                        red = 1;
                        green = 3;
                        break block0;
                    }
                    case HIGHSHELF: {
                        red = 1;
                        green = 2;
                        break block0;
                    }
                    case LOWSHELF: {
                        red = 3;
                        break block0;
                    }
                    case LOWCUT: {
                        red = 2;
                        break block0;
                    }
                    case NOTCH: {
                        red = 3;
                        green = 3;
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                green = value == 0 ? 0 : value / 42 + 1;
                break;
            }
            case 2: {
                int n = green = value == 0 ? 0 : value / 42 + 1;
                if (this.configuration.isDeviceActive()) {
                    red = green == 0 ? 0 : 1;
                    break;
                }
                red = green;
                break;
            }
            default: {
                return;
            }
        }
        ((LaunchControlXLControlSurface)this.surface).setKnobLEDColor(row, column, green, red);
    }

    @Override
    public void onActivate() {
        this.trackSelectionChanged(-1, true);
        super.onActivate();
    }

    private void trackSelectionChanged(int index, boolean isSelected) {
        Optional selectedTrack;
        if (!isSelected || !this.isActive) {
            return;
        }
        if (!this.eqDevice.doesExist() && (selectedTrack = this.model.getCurrentTrackBank().getSelectedItem()).isPresent()) {
            ((ITrack)selectedTrack.get()).addEqualizerDevice();
        }
    }
}

