/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchcontrol.mode.buttons;

import de.mossgrabers.controller.novation.launchcontrol.LaunchControlXLConfiguration;
import de.mossgrabers.controller.novation.launchcontrol.controller.LaunchControlXLControlSurface;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.IStepInfo;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.mode.sequencer.AbstractSequencerMode;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.Optional;

public class XLDrumSequencerMode
extends AbstractSequencerMode<LaunchControlXLControlSurface, LaunchControlXLConfiguration> {
    protected int numColumns;
    protected int sequencerSteps;
    protected int sequencerLines;
    protected final Configuration configuration = ((LaunchControlXLControlSurface)this.surface).getConfiguration();
    protected int selectedPad = 0;
    protected final Scales scales;

    public XLDrumSequencerMode(LaunchControlXLControlSurface surface, IModel model) {
        super("Note Sequencer", surface, model, true, 127, 8, false);
        this.scales = model.getScales();
        this.sequencerLines = 1;
        this.numColumns = this.clipCols;
        this.sequencerSteps = this.sequencerLines * this.numColumns;
    }

    public void setSelectedPad(int selectedPad) {
        this.selectedPad = selectedPad;
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        int index = buttonID.ordinal() - ButtonID.ROW2_1.ordinal();
        if (index < 0 || index >= 8) {
            return 12;
        }
        INoteClip clip = this.getClip();
        int noteRow = this.scales.getDrumOffset() + this.selectedPad;
        return this.getSequencerStepColor(clip, noteRow, index, Optional.empty());
    }

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        int noteRow = this.scales.getDrumOffset() + this.selectedPad;
        NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), index, noteRow);
        this.getClip().toggleStep(notePosition, 127);
    }

    protected int getSequencerStepColor(INoteClip clip, int noteRow, int column, Optional<ColorEx> rowColor) {
        int step = clip.getCurrentStep();
        int hiStep = this.isInXRange(step) ? step % this.sequencerSteps : -1;
        NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), column, noteRow);
        IStepInfo stepInfo = clip.getStep(notePosition);
        boolean hilite = column == hiStep;
        String colorID = this.isActive() ? this.getStepColor(stepInfo, hilite, rowColor, column) : "COLOR_NO_CONTENT";
        return this.colorManager.getColorIndex(colorID);
    }

    private boolean isActive() {
        return this.model.canSelectedTrackHoldNotes() && this.getClip().doesExist();
    }

    protected boolean isInXRange(int x) {
        INoteClip clip = this.getClip();
        int stepSize = clip.getNumSteps();
        int start = clip.getEditPage() * stepSize;
        return x >= start && x < start + stepSize;
    }

    protected String getStepColor(IStepInfo stepInfo, boolean hilite, Optional<ColorEx> rowColor, int step) {
        switch (stepInfo.getState()) {
            case START: {
                if (hilite) {
                    return "COLOR_STEP_HILITE_CONTENT";
                }
                if (stepInfo.isMuted()) {
                    return "COLOR_STEP_MUTED";
                }
                return rowColor.isPresent() && this.useDawColors ? DAWColor.getColorID(rowColor.get()) : "COLOR_CONTENT";
            }
            case CONTINUE: {
                if (hilite) {
                    return "COLOR_STEP_HILITE_CONTENT";
                }
                if (stepInfo.isMuted()) {
                    return "COLOR_STEP_MUTED_CONT";
                }
                return rowColor.isPresent() && this.useDawColors ? DAWColor.getColorID(ColorEx.darker(rowColor.get())) : "COLOR_CONTENT_CONT";
            }
        }
        if (hilite) {
            return "COLOR_STEP_HILITE_NO_CONTENT";
        }
        return step / 4 % 2 == 1 ? "COLOR_NO_CONTENT_4" : "COLOR_NO_CONTENT";
    }

    public int getSelectedPad() {
        return this.selectedPad;
    }
}

