/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchcontrol;

import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import java.util.List;

public class LaunchControlXLConfiguration
extends AbstractConfiguration {
    public static final Integer ACTIVE_TEMPLATE = 100;
    private int templateID = -1;
    private boolean isDeviceActive = false;

    public LaunchControlXLConfiguration(IHost host, IValueChanger valueChanger, List<ArpeggiatorMode> arpeggiatorModes) {
        super(host, valueChanger, arpeggiatorModes);
    }

    @Override
    public void init(ISettingsUI globalSettings, ISettingsUI documentSettings) {
        this.activateScaleSetting(documentSettings);
        this.activateScaleBaseSetting(documentSettings);
        this.activateScaleInScaleSetting(documentSettings);
        this.activateBehaviourOnPauseSetting(globalSettings);
        this.activateMidiEditChannelSetting(globalSettings);
        this.activateExcludeDeactivatedItemsSetting(globalSettings);
        this.activateNewClipLengthSetting(globalSettings);
    }

    public void setTemplate(int templateID) {
        this.templateID = templateID;
        this.notifyObservers(ACTIVE_TEMPLATE);
    }

    public int getTemplate() {
        return this.templateID;
    }

    public boolean isDeviceActive() {
        return this.isDeviceActive;
    }

    public void toggleDeviceActive() {
        this.isDeviceActive = !this.isDeviceActive;
    }
}

