/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.mk3.mode;

import de.mossgrabers.controller.ni.maschine.mk3.MaschineConfiguration;
import de.mossgrabers.controller.ni.maschine.mk3.controller.MaschineControlSurface;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.mode.track.TrackPanMode;
import de.mossgrabers.framework.utils.StringUtils;

public class MaschinePanMode
extends TrackPanMode<MaschineControlSurface, MaschineConfiguration> {
    public MaschinePanMode(MaschineControlSurface surface, IModel model) {
        super(surface, model, false, surface.getMaschine().hasMCUDisplay() ? DEFAULT_KNOB_IDS : null);
        this.initTouchedStates(9);
    }

    @Override
    public void updateDisplay() {
        ITextDisplay d = ((MaschineControlSurface)this.surface).getTextDisplay();
        ITrackBank tb = this.model.getCurrentTrackBank();
        for (int i = 0; i < 8; ++i) {
            ITrack t = (ITrack)tb.getItem(i);
            Object name = StringUtils.shortenAndFixASCII(t.getName(), 6);
            if (t.isSelected()) {
                name = ">" + (String)name;
            }
            d.setCell(0, i, (String)name);
            d.setCell(1, i, t.getPanStr(6));
        }
        d.allDone();
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.setTouchedKnob(index, isTouched);
        super.onKnobTouch(index == 8 ? -1 : index, isTouched);
    }
}

