/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.mk3.mode;

import de.mossgrabers.controller.ni.maschine.mk3.controller.MaschineControlSurface;
import de.mossgrabers.controller.ni.maschine.mk3.mode.BaseMode;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IBrowserColumn;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.Optional;

public class BrowseMode
extends BaseMode {
    private int filterColumn = -1;
    private int selColumn = 7;

    public BrowseMode(MaschineControlSurface surface, IModel model) {
        super("Browser", surface, model);
    }

    @Override
    public void onDeactivate() {
        super.onDeactivate();
        this.model.getBrowser().stopBrowsing(true);
    }

    @Override
    public void onKnobValue(int index, int value) {
        int speed = this.model.getValueChanger().calcSteppedKnobChange(value);
        if (speed < 0) {
            this.selectPrevious(index < 0 ? this.selColumn : index, Math.abs(speed));
        } else {
            this.selectNext(index < 0 ? this.selColumn : index, Math.abs(speed));
        }
    }

    @Override
    public void updateDisplay() {
        IBrowser browser = this.model.getBrowser();
        ITextDisplay d = ((MaschineControlSurface)this.surface).getTextDisplay();
        boolean isPresetSession = browser.isPresetContentType();
        ICursorDevice cd = this.model.getCursorDevice();
        if (!(!isPresetSession || browser.isActive() && cd.doesExist())) {
            d.notify("No active Browsing Session. Select device and press Browser...");
            return;
        }
        d.clear();
        for (int i = 0; i < 7; ++i) {
            Optional<IBrowserColumn> column = this.getFilterColumn(i);
            String value = "";
            Object name = "";
            if (column.isPresent()) {
                IBrowserColumn browserColumn = column.get();
                if (browserColumn.doesCursorExist()) {
                    value = browserColumn.getCursorName().equals(browserColumn.getWildcard()) ? "-" : browserColumn.getCursorName();
                }
                name = StringUtils.shortenAndFixASCII(browserColumn.getName(), 6);
            }
            if (i == this.getSelectedParameter()) {
                name = ">" + (String)name;
            }
            d.setCell(0, i, (String)name).setCell(1, i, value);
        }
        String selectedResult = browser.getSelectedResult();
        Object selectedContentType = browser.getSelectedContentType();
        if (this.getSelectedParameter() == 7) {
            selectedContentType = ">" + (String)selectedContentType;
        }
        d.setCell(0, 7, (String)selectedContentType).setCell(1, 7, selectedResult == null || selectedResult.length() == 0 ? "-" : selectedResult);
        d.allDone();
    }

    public void selectParameter(int index) {
        this.selColumn = index;
    }

    public int getSelectedParameter() {
        return this.selColumn == -1 ? 0 : this.selColumn;
    }

    private Optional<IBrowserColumn> getFilterColumn(int index) {
        IBrowser browser = this.model.getBrowser();
        int column = -1;
        for (int i = 0; i < browser.getFilterColumnCount(); ++i) {
            if (++column != index) continue;
            return Optional.of(browser.getFilterColumn(i));
        }
        return Optional.empty();
    }

    private void selectNext(int index, int count) {
        block3: {
            IBrowser browser;
            block2: {
                browser = this.model.getBrowser();
                if (index >= 7) break block2;
                Optional<IBrowserColumn> fc = this.getFilterColumn(index);
                if (!fc.isPresent() || !fc.get().doesExist()) break block3;
                this.filterColumn = fc.get().getIndex();
                for (int i = 0; i < count; ++i) {
                    browser.selectNextFilterItem(this.filterColumn);
                }
                if (browser.getSelectedFilterItemIndex(this.filterColumn) != -1) break block3;
                browser.nextFilterItemPage(this.filterColumn);
                break block3;
            }
            for (int i = 0; i < count; ++i) {
                browser.selectNextResult();
            }
        }
    }

    private void selectPrevious(int index, int count) {
        IBrowser browser = this.model.getBrowser();
        for (int i = 0; i < count; ++i) {
            if (index < 7) {
                Optional<IBrowserColumn> fc = this.getFilterColumn(index);
                if (!fc.isPresent() || !fc.get().doesExist()) continue;
                this.filterColumn = fc.get().getIndex();
                for (int j = 0; j < count; ++j) {
                    browser.selectPreviousFilterItem(this.filterColumn);
                }
                if (browser.getSelectedFilterItemIndex(this.filterColumn) != -1) continue;
                browser.previousFilterItemPage(this.filterColumn);
                continue;
            }
            for (int j = 0; j < count; ++j) {
                browser.selectPreviousResult();
            }
        }
    }

    @Override
    public void selectPreviousItem() {
        if (((MaschineControlSurface)this.surface).isShiftPressed()) {
            this.selectPreviousItemPage();
            return;
        }
        int selectedParameter = this.getSelectedParameter();
        if (selectedParameter > 0) {
            this.selectParameter(selectedParameter - 1);
        }
    }

    @Override
    public void selectNextItem() {
        if (((MaschineControlSurface)this.surface).isShiftPressed()) {
            this.selectNextItemPage();
            return;
        }
        int selectedParameter = this.getSelectedParameter();
        if (selectedParameter < 7) {
            this.selectParameter(selectedParameter + 1);
        }
    }

    @Override
    public void selectPreviousItemPage() {
        this.model.getBrowser().previousContentType();
    }

    @Override
    public void selectNextItemPage() {
        this.model.getBrowser().nextContentType();
    }

    @Override
    public boolean hasPreviousItem() {
        return this.getSelectedParameter() > 0;
    }

    @Override
    public boolean hasNextItem() {
        return this.getSelectedParameter() < 7;
    }

    @Override
    public boolean hasPreviousItemPage() {
        return this.model.getBrowser().hasPreviousContentType();
    }

    @Override
    public boolean hasNextItemPage() {
        return this.model.getBrowser().hasNextContentType();
    }
}

