/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.mk3.command.trigger;

import de.mossgrabers.controller.ni.maschine.mk3.MaschineConfiguration;
import de.mossgrabers.controller.ni.maschine.mk3.controller.MaschineControlSurface;
import de.mossgrabers.controller.ni.maschine.mk3.mode.EditNoteMode;
import de.mossgrabers.framework.command.trigger.mode.ModeMultiSelectCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.parameter.NoteAttribute;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;

public class SwingCommand
extends ModeMultiSelectCommand<MaschineControlSurface, MaschineConfiguration> {
    public SwingCommand(IModel model, MaschineControlSurface surface) {
        super(model, surface, Modes.POSITION, Modes.LOOP_START, Modes.LOOP_LENGTH);
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        ModeManager modeManager = ((MaschineControlSurface)this.surface).getModeManager();
        if (modeManager.isActive(new Modes[]{Modes.NOTE}) && ((MaschineControlSurface)this.surface).getViewManager().isActive(new Views[]{Views.DRUM, Views.PLAY})) {
            if (event == ButtonEvent.DOWN) {
                EditNoteMode mode = (EditNoteMode)modeManager.get(Modes.NOTE);
                boolean isPanning = mode.getActiveParameter() == NoteAttribute.PANNING;
                mode.selectActiveParameter(isPanning ? NoteAttribute.DURATION : NoteAttribute.PANNING);
                ((MaschineControlSurface)this.surface).getDisplay().notify(isPanning ? "Duration" : "Panning");
            }
            return;
        }
        super.execute(event, velocity);
    }
}

