/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.mcu.mode.track;

import de.mossgrabers.controller.mackie.mcu.MCUConfiguration;
import de.mossgrabers.controller.mackie.mcu.controller.MCUControlSurface;
import de.mossgrabers.controller.mackie.mcu.mode.BaseMode;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IApplication;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.empty.EmptyParameter;
import de.mossgrabers.framework.parameterprovider.special.FixedParameterProvider;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;

public class MasterMode
extends BaseMode<ITrack> {
    public MasterMode(MCUControlSurface surface, IModel model) {
        super("Master", surface, model);
        IMasterTrack masterTrack = this.model.getMasterTrack();
        this.setParameterProvider(new FixedParameterProvider(masterTrack.getVolumeParameter(), masterTrack.getPanParameter(), EmptyParameter.INSTANCE, EmptyParameter.INSTANCE, EmptyParameter.INSTANCE, EmptyParameter.INSTANCE, EmptyParameter.INSTANCE, EmptyParameter.INSTANCE));
    }

    @Override
    public void onActivate() {
        super.onActivate();
        this.setActive(true);
    }

    @Override
    public void onDeactivate() {
        super.onDeactivate();
        this.setActive(false);
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.setTouchedKnob(index, isTouched);
        if (index == 0) {
            this.model.getMasterTrack().touchVolume(isTouched);
        } else if (index == 1) {
            this.model.getMasterTrack().touchPan(isTouched);
        }
    }

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
        if (event == ButtonEvent.DOWN && row > 0) {
            ((MCUControlSurface)this.surface).getModeManager().restore();
            return;
        }
        int extenderOffset = this.getExtenderOffset();
        if (extenderOffset > 0 || event != ButtonEvent.UP || row > 0) {
            return;
        }
        switch (index) {
            case 0: {
                this.resetParameter(this.model.getMasterTrack().getVolumeParameter());
                break;
            }
            case 1: {
                this.resetParameter(this.model.getMasterTrack().getPanParameter());
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.model.getApplication().toggleEngineActive();
                break;
            }
            case 6: {
                this.model.getProject().previous();
                break;
            }
            case 7: {
                this.model.getProject().next();
                break;
            }
        }
    }

    @Override
    public void updateDisplay() {
        MCUConfiguration.MainDisplay mainDisplayType = this.configuration.getMainDisplayType();
        if (mainDisplayType == MCUConfiguration.MainDisplay.NONE) {
            return;
        }
        this.drawDisplay2();
        ITextDisplay d = ((MCUControlSurface)this.surface).getTextDisplay().clear();
        String projectName = StringUtils.fixASCII(this.model.getProject().getName());
        IMasterTrack master = this.model.getMasterTrack();
        ColorEx[] colors = new ColorEx[8];
        int extenderOffset = this.getExtenderOffset();
        if (extenderOffset == 0) {
            int textLength = this.getTextLength();
            IApplication application = this.model.getApplication();
            d.setCell(0, 0, "Volume").setCell(0, 1, "Pan");
            if (mainDisplayType == MCUConfiguration.MainDisplay.MACKIE_7_CHARACTERS) {
                d.setBlock(0, 1, "  AudioEngine:").setCell(0, 4, application.isEngineActive() ? "On" : "Off");
                d.setCell(0, 5, "Prjct:").setBlock(0, 3, projectName);
                d.setCell(1, 0, master.getVolumeStr(textLength)).setCell(1, 1, master.getPanStr(textLength)).setBlock(1, 1, application.isEngineActive() ? "   Turnoff" : "   Turnon");
                d.setCell(1, 6, "   <<").setCell(1, 7, "   >>").allDone();
            } else {
                d.setBlock(0, 1, "Audio Engine:").setCell(0, 4, application.isEngineActive() ? " On" : " Off");
                d.setCell(0, 5, "Prjct:").setBlock(0, 3, projectName);
                d.setCell(1, 0, master.getVolumeStr(textLength)).setCell(1, 1, master.getPanStr(textLength)).setBlock(1, 1, application.isEngineActive() ? "  Turn off" : "  Turn on");
                d.setCell(1, 6, " <<").setCell(1, 7, " >>").allDone();
            }
            colors[0] = master.getColor();
            colors[1] = master.getColor();
            colors[2] = ColorEx.SKY_BLUE;
            colors[3] = ColorEx.SKY_BLUE;
            colors[4] = ColorEx.SKY_BLUE;
            colors[5] = ColorEx.WHITE;
            colors[6] = ColorEx.WHITE;
            colors[7] = ColorEx.WHITE;
        } else {
            for (int i = 0; i < 8; ++i) {
                colors[i] = ColorEx.BLACK;
            }
        }
        ((MCUControlSurface)this.surface).sendDisplayColor(colors);
    }

    private void setActive(boolean enable) {
        IMasterTrack mt = this.model.getMasterTrack();
        mt.setVolumeIndication(enable);
        mt.setPanIndication(enable);
    }

    @Override
    public void updateKnobLEDs() {
        int extenderOffset = this.getExtenderOffset();
        if (extenderOffset > 0) {
            for (int i = 0; i < 8; ++i) {
                ((MCUControlSurface)this.surface).setKnobLED(i, 2, 0, 0);
            }
            return;
        }
        IMasterTrack masterTrack = this.model.getMasterTrack();
        int upperBound = this.model.getValueChanger().getUpperBound();
        ((MCUControlSurface)this.surface).setKnobLED(0, 2, masterTrack.getVolume(), upperBound);
        ((MCUControlSurface)this.surface).setKnobLED(1, 1, masterTrack.getPan(), upperBound);
        for (int i = 0; i < 6; ++i) {
            ((MCUControlSurface)this.surface).setKnobLED(2 + i, 2, 0, upperBound);
        }
    }

    @Override
    protected void resetParameter(int index) {
    }
}

