/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.generic.flexihandler.utils;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProgramBank {
    private static final Pattern BANK_PATTERN = Pattern.compile("\\$BANK=(.+)\\$MSB=(\\d+)\\$LSB=(\\d+)\\$CHANNEL=(\\d+)", 64);
    private String name;
    private int msb;
    private int lsb;
    private int channel;
    private String[] programs;
    private final Map<String, Integer> programMapper = new HashMap<String, Integer>(128);

    public static List<ProgramBank> parse(String text) throws ParseException {
        Matcher matcher;
        ArrayList<ProgramBank> banks = new ArrayList<ProgramBank>();
        int pos = 0;
        String[] lines = text.split("\\R");
        while (pos < lines.length && (matcher = BANK_PATTERN.matcher(lines[pos])).matches()) {
            ProgramBank pb = new ProgramBank();
            pb.name = matcher.group(1);
            if (pb.name == null || pb.name.isBlank()) {
                throw new ParseException("Missing BANK name.", pos);
            }
            String msb = matcher.group(2);
            if (msb == null || msb.isBlank()) {
                throw new ParseException("Missing MSB value.", pos);
            }
            String lsb = matcher.group(3);
            if (lsb == null || lsb.isBlank()) {
                throw new ParseException("Missing LSB value.", pos);
            }
            String channel = matcher.group(4);
            if (channel == null || channel.isBlank()) {
                throw new ParseException("Missing CHANNEL value.", pos);
            }
            try {
                pb.msb = Integer.parseInt(msb);
                if (pb.msb < 0 || pb.msb > 127) {
                    throw new NumberFormatException("Value must be in the range of 0..127");
                }
            }
            catch (NumberFormatException ex) {
                throw new ParseException("MSB value must be a number in the range of 0 to 127.", pos);
            }
            try {
                pb.lsb = Integer.parseInt(lsb);
                if (pb.lsb < 0 || pb.lsb > 127) {
                    throw new NumberFormatException("Value must be in the range of 0..127");
                }
            }
            catch (NumberFormatException ex) {
                throw new ParseException("LSB value must be a number in the range of 0 to 127.", pos);
            }
            try {
                pb.channel = Integer.parseInt(channel);
                if (pb.channel < 0 || pb.channel > 15) {
                    throw new NumberFormatException("Value must be in the range of 0..15");
                }
            }
            catch (NumberFormatException ex) {
                throw new ParseException("LSB value must be a number in the range of 0 to 127.", pos);
            }
            banks.add(pb);
            ++pos;
            ArrayList<String> programs = new ArrayList<String>(128);
            while (pos < lines.length && !lines[pos].startsWith("$BANK=")) {
                pb.programMapper.put(lines[pos], programs.size());
                programs.add(lines[pos]);
                ++pos;
            }
            if (programs.isEmpty() || programs.size() > 128) {
                throw new ParseException("There must be at least 1 program and not more than 128.", pos);
            }
            pb.programs = programs.toArray(new String[programs.size()]);
        }
        if (banks.isEmpty()) {
            throw new ParseException("Could not parse any banks. Check file format.", pos);
        }
        return banks;
    }

    public String getName() {
        return this.name;
    }

    public int getMSB() {
        return this.msb;
    }

    public int getLSB() {
        return this.lsb;
    }

    public int getMidiChannel() {
        return this.channel;
    }

    public String[] getPrograms() {
        return this.programs;
    }

    public int lookupProgram(String programName) {
        Integer pc = this.programMapper.get(programName);
        return pc == null ? -1 : pc;
    }
}

