/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.generic.flexihandler.utils;

import java.util.HashMap;
import java.util.Map;

public class MidiValue {
    private static final Map<Integer, MidiValue> HI_RES_VALUES = new HashMap<Integer, MidiValue>(16384);
    private static final Map<Integer, MidiValue> LO_RES_VALUES = new HashMap<Integer, MidiValue>(128);
    private final boolean isHighRes;
    private final int value;
    private final int upscaled;

    private MidiValue(int value, boolean isHighRes) {
        this.isHighRes = isHighRes;
        this.value = value;
        this.upscaled = this.isHighRes ? value : (int)Math.round((double)value * 16383.0 / 127.0);
    }

    public static MidiValue get(int value, boolean isHighRes) {
        if (isHighRes) {
            return HI_RES_VALUES.computeIfAbsent(value, val -> new MidiValue((int)val, true));
        }
        return LO_RES_VALUES.computeIfAbsent(value, val -> new MidiValue((int)val, false));
    }

    public boolean isPositive() {
        return this.value > 0;
    }

    public boolean isHighRes() {
        return this.isHighRes;
    }

    public int getValue() {
        return this.value;
    }

    public int getUpscaled() {
        return this.upscaled;
    }
}

