/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.generic.flexihandler;

import de.mossgrabers.controller.generic.GenericFlexiConfiguration;
import de.mossgrabers.controller.generic.controller.FlexiCommand;
import de.mossgrabers.controller.generic.controller.GenericFlexiControlSurface;
import de.mossgrabers.controller.generic.flexihandler.AbstractHandler;
import de.mossgrabers.controller.generic.flexihandler.utils.FlexiHandlerException;
import de.mossgrabers.controller.generic.flexihandler.utils.KnobMode;
import de.mossgrabers.controller.generic.flexihandler.utils.MidiValue;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.Capability;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import de.mossgrabers.framework.daw.midi.INoteInput;
import de.mossgrabers.framework.daw.midi.INoteRepeat;
import de.mossgrabers.framework.scale.Scales;
import java.util.List;

public class NoteInputHandler
extends AbstractHandler {
    private final IHost host;

    public NoteInputHandler(IModel model, GenericFlexiControlSurface surface, GenericFlexiConfiguration configuration, IValueChanger absoluteLowResValueChanger, IValueChanger signedBitRelativeValueChanger, IValueChanger signedBit2RelativeValueChanger, IValueChanger offsetBinaryRelativeValueChanger) {
        super(model, surface, configuration, absoluteLowResValueChanger, signedBitRelativeValueChanger, signedBit2RelativeValueChanger, offsetBinaryRelativeValueChanger);
        this.host = this.model.getHost();
    }

    @Override
    public FlexiCommand[] getSupportedCommands() {
        return new FlexiCommand[]{FlexiCommand.NOTE_INPUT_REPEAT_ACTIVE, FlexiCommand.NOTE_INPUT_REPEAT_PERIOD, FlexiCommand.NOTE_INPUT_REPEAT_LENGTH, FlexiCommand.NOTE_INPUT_REPEAT_MODE, FlexiCommand.NOTE_INPUT_REPEAT_OCTAVE, FlexiCommand.NOTE_INPUT_TRANSPOSE_OCTAVE_UP, FlexiCommand.NOTE_INPUT_TRANSPOSE_OCTAVE_DOWN};
    }

    @Override
    public int getCommandValue(FlexiCommand command) {
        INoteInput noteInput = this.surface.getMidiInput().getDefaultNoteInput();
        if (noteInput == null) {
            return -1;
        }
        INoteRepeat noteRepeat = noteInput.getNoteRepeat();
        GenericFlexiConfiguration configuration = (GenericFlexiConfiguration)this.surface.getConfiguration();
        switch (command) {
            case NOTE_INPUT_REPEAT_ACTIVE: {
                return NoteInputHandler.toMidiValue(noteRepeat.isActive());
            }
            case NOTE_INPUT_REPEAT_PERIOD: {
                return Resolution.getMatch(noteRepeat.getPeriod());
            }
            case NOTE_INPUT_REPEAT_LENGTH: {
                return Resolution.getMatch(noteRepeat.getNoteLength());
            }
            case NOTE_INPUT_REPEAT_MODE: {
                ArpeggiatorMode am = noteRepeat.getMode();
                int index = configuration.getArpeggiatorModes().indexOf((Object)am);
                return Math.max(0, index);
            }
            case NOTE_INPUT_REPEAT_OCTAVE: {
                return noteRepeat.getOctaves();
            }
            case NOTE_INPUT_TRANSPOSE_OCTAVE_UP: 
            case NOTE_INPUT_TRANSPOSE_OCTAVE_DOWN: {
                return this.model.getScales().getOctave();
            }
        }
        return -1;
    }

    @Override
    public void handle(FlexiCommand command, KnobMode knobMode, MidiValue value) {
        boolean isButtonPressed = this.isButtonPressed(knobMode, value);
        GenericFlexiConfiguration configuration = (GenericFlexiConfiguration)this.surface.getConfiguration();
        Resolution[] resolutions = Resolution.values();
        Scales scales = this.model.getScales();
        double val = value.isHighRes() ? (double)value.getValue() / 128.0 : (double)value.getValue();
        switch (command) {
            case NOTE_INPUT_REPEAT_ACTIVE: {
                if (!isButtonPressed) break;
                configuration.toggleNoteRepeatActive();
                this.mvHelper.delayDisplay(() -> "Repeat: " + (configuration.isNoteRepeatActive() ? "On" : "Off"));
                break;
            }
            case NOTE_INPUT_REPEAT_PERIOD: {
                int selPeriod = NoteInputHandler.isAbsolute(knobMode) ? (int)Math.min(Math.round(val / 127.0 * (double)resolutions.length), (long)resolutions.length - 1L) : Resolution.change(Resolution.getMatch(configuration.getNoteRepeatPeriod().getValue()), this.isIncrease(knobMode, value));
                configuration.setNoteRepeatPeriod(resolutions[selPeriod]);
                this.mvHelper.delayDisplay(() -> "Repeat Period: " + configuration.getNoteRepeatPeriod().getName());
                break;
            }
            case NOTE_INPUT_REPEAT_LENGTH: {
                if (!this.model.getHost().supports(Capability.NOTE_REPEAT_LENGTH)) break;
                int selLength = NoteInputHandler.isAbsolute(knobMode) ? (int)Math.min(Math.round(val / 127.0 * (double)resolutions.length), (long)resolutions.length - 1L) : Resolution.change(Resolution.getMatch(configuration.getNoteRepeatLength().getValue()), this.isIncrease(knobMode, value));
                configuration.setNoteRepeatLength(resolutions[selLength]);
                this.mvHelper.delayDisplay(() -> "Repeat Length: " + configuration.getNoteRepeatLength().getName());
                break;
            }
            case NOTE_INPUT_REPEAT_MODE: {
                int newIndex;
                if (!this.host.supports(Capability.NOTE_REPEAT_MODE)) break;
                List<ArpeggiatorMode> modes = configuration.getArpeggiatorModes();
                if (NoteInputHandler.isAbsolute(knobMode)) {
                    if (val >= (double)modes.size()) {
                        return;
                    }
                    newIndex = (int)val;
                } else {
                    ArpeggiatorMode arpMode = configuration.getNoteRepeatMode();
                    int modeIndex = configuration.lookupArpeggiatorModeIndex(arpMode);
                    boolean increase = this.isIncrease(knobMode, value);
                    newIndex = Math.max(0, Math.min(modes.size() - 1, modeIndex + (increase ? 1 : -1)));
                }
                configuration.setNoteRepeatMode(modes.get(newIndex));
                this.mvHelper.delayDisplay(() -> "Repeat Mode: " + ((ArpeggiatorMode)((Object)((Object)modes.get(newIndex)))).getName());
                break;
            }
            case NOTE_INPUT_REPEAT_OCTAVE: {
                if (!this.host.supports(Capability.NOTE_REPEAT_OCTAVES)) break;
                int octave = NoteInputHandler.isAbsolute(knobMode) ? (int)val : configuration.getNoteRepeatOctave() + (this.isIncrease(knobMode, value) ? 1 : -1);
                configuration.setNoteRepeatOctave(octave);
                this.mvHelper.delayDisplay(() -> "Repeat Octave: " + octave);
                break;
            }
            case NOTE_INPUT_TRANSPOSE_OCTAVE_UP: {
                if (!isButtonPressed) break;
                scales.incOctave();
                this.updateOctave(scales);
                break;
            }
            case NOTE_INPUT_TRANSPOSE_OCTAVE_DOWN: {
                if (!isButtonPressed) break;
                scales.decOctave();
                this.updateOctave(scales);
                break;
            }
            default: {
                throw new FlexiHandlerException(command);
            }
        }
    }

    private void updateOctave(Scales scales) {
        this.surface.scheduleTask(() -> {
            this.surface.setKeyTranslationTable(scales.getNoteMatrix());
            this.mvHelper.delayDisplay(() -> "Octave: " + scales.getOctave());
        }, 6L);
    }
}

