/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.fire.mode;

import de.mossgrabers.controller.akai.fire.FireConfiguration;
import de.mossgrabers.controller.akai.fire.controller.FireControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.IDrumDevice;
import de.mossgrabers.framework.daw.data.ILayer;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import de.mossgrabers.framework.graphics.canvas.component.simple.TitleValueComponent;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.parameterprovider.device.SelectedLayerOrDrumPadParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.FourKnobProvider;
import java.util.Optional;

public class FireLayerMode
extends AbstractParameterMode<FireControlSurface, FireConfiguration, ILayer> {
    private static final Modes[] MODES = new Modes[]{Modes.VOLUME, Modes.PAN, Modes.SEND1, Modes.SEND2};
    private static final Modes[] ALT_MODES = new Modes[]{Modes.SEND3, Modes.SEND4, Modes.SEND5, Modes.SEND6};
    protected Modes selectedParameter = Modes.VOLUME;

    public FireLayerMode(FireControlSurface surface, IModel model) {
        this("Channel", surface, model);
    }

    public FireLayerMode(String name, FireControlSurface surface, IModel model) {
        super(name, surface, model);
        this.setControls(ContinuousID.createSequentialList(ContinuousID.KNOB1, 4));
        this.setParameterProvider(new FourKnobProvider(surface, new SelectedLayerOrDrumPadParameterProvider(this.getDrumDevice()), ButtonID.ALT));
    }

    @Override
    public void updateDisplay() {
        this.updateMode();
        IGraphicDisplay display = ((FireControlSurface)this.surface).getGraphicsDisplay();
        Object desc = "Select";
        Object label = "a drum pad";
        int value = -1;
        int vuLeft = -1;
        int vuRight = -1;
        boolean isPan = false;
        Optional channelOptional = this.getDrumDevice().getLayerBank().getSelectedItem();
        if (channelOptional.isPresent()) {
            IChannel channel = (IChannel)channelOptional.get();
            vuLeft = channel.getVuLeft();
            vuRight = channel.getVuRight();
            desc = channel.getPosition() + 1 + ": " + channel.getName(9);
            ISendBank sendBank = channel.getSendBank();
            switch (this.selectedParameter) {
                case VOLUME: {
                    label = "Vol: " + channel.getVolumeStr();
                    value = channel.getVolume();
                    break;
                }
                case PAN: {
                    label = "Pan: " + channel.getPanStr();
                    value = channel.getPan();
                    isPan = true;
                    break;
                }
                case SEND1: 
                case SEND2: 
                case SEND3: 
                case SEND4: 
                case SEND5: 
                case SEND6: {
                    int sendIndex = this.selectedParameter.ordinal() - Modes.SEND1.ordinal();
                    label = FireLayerMode.getSendLabel(sendBank, sendIndex);
                    value = FireLayerMode.getSendValue(sendBank, sendIndex);
                    break;
                }
                default: {
                    label = "Select a track";
                }
            }
        }
        display.addElement(new TitleValueComponent((String)desc, (String)label, value, vuLeft, vuRight, isPan));
        display.send();
    }

    protected void updateMode() {
        int index = -1;
        Modes[] ms = ((FireControlSurface)this.surface).isPressed(ButtonID.ALT) ? MODES : ALT_MODES;
        for (int i = 0; i < ms.length; ++i) {
            if (ms[i] != this.selectedParameter) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            this.selectedParameter = ((FireControlSurface)this.surface).isPressed(ButtonID.ALT) ? ALT_MODES[index] : MODES[index];
        }
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.selectedParameter = ((FireControlSurface)this.surface).isPressed(ButtonID.ALT) ? ALT_MODES[index] : MODES[index];
        this.setTouchedKnob(index, isTouched);
        Optional channelOptional = this.getDrumDevice().getLayerBank().getSelectedItem();
        if (!channelOptional.isPresent()) {
            return;
        }
        IChannel channel = (IChannel)channelOptional.get();
        switch (this.selectedParameter) {
            case VOLUME: {
                if (isTouched && ((FireControlSurface)this.surface).isDeletePressed()) {
                    channel.resetVolume();
                }
                channel.touchVolume(isTouched);
                break;
            }
            case PAN: {
                if (isTouched && ((FireControlSurface)this.surface).isDeletePressed()) {
                    channel.resetPan();
                }
                channel.touchPan(isTouched);
                break;
            }
            case SEND1: 
            case SEND2: 
            case SEND3: 
            case SEND4: 
            case SEND5: 
            case SEND6: {
                int sendIndex = this.selectedParameter.ordinal() - Modes.SEND1.ordinal();
                ISend item = (ISend)channel.getSendBank().getItem(sendIndex);
                if (isTouched && ((FireControlSurface)this.surface).isDeletePressed()) {
                    item.resetValue();
                }
                item.touchValue(isTouched);
                break;
            }
        }
    }

    private static String getSendLabel(ISendBank sendBank, int index) {
        int pos = index + 1;
        if (sendBank == null) {
            return "No FX " + pos;
        }
        ISend send = (ISend)sendBank.getItem(index);
        if (!send.doesExist()) {
            return "No FX " + pos;
        }
        return send.getName(4) + ": " + send.getDisplayedValue();
    }

    private static int getSendValue(ISendBank sendBank, int index) {
        if (sendBank == null) {
            return 0;
        }
        ISend send = (ISend)sendBank.getItem(index);
        return send.doesExist() ? send.getValue() : 0;
    }

    private IDrumDevice getDrumDevice() {
        return this.model.getDrumDevice(16);
    }
}

