/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.fire.command.continuous;

import de.mossgrabers.controller.akai.fire.FireConfiguration;
import de.mossgrabers.controller.akai.fire.controller.FireControlSurface;
import de.mossgrabers.controller.akai.fire.mode.FireUserMode;
import de.mossgrabers.controller.akai.fire.view.IFireView;
import de.mossgrabers.framework.command.core.AbstractContinuousCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.parameter.IFocusedParameter;
import de.mossgrabers.framework.utils.Timeout;
import java.util.Optional;

public class SelectKnobCommand
extends AbstractContinuousCommand<FireControlSurface, FireConfiguration> {
    private final Timeout timeout;

    public SelectKnobCommand(IModel model, FireControlSurface surface) {
        super(model, surface);
        this.timeout = new Timeout(model.getHost(), 500);
    }

    @Override
    public void execute(int value) {
        ModeManager modeManager = ((FireControlSurface)this.surface).getModeManager();
        if (modeManager.isActive(new Modes[]{Modes.BROWSER})) {
            IMode mode = (IMode)modeManager.get(Modes.BROWSER);
            mode.onKnobTouch(8, true);
            mode.onKnobValue(8, value);
            this.checkUntouch(8);
            return;
        }
        if (((FireControlSurface)this.surface).isPressed(ButtonID.ALT)) {
            boolean isInc = this.model.getValueChanger().isIncrease(value);
            if (modeManager.isActive(new Modes[]{Modes.TRACK, Modes.VOLUME, Modes.DEVICE_LAYER, Modes.DEVICE_LAYER_VOLUME, Modes.NOTE})) {
                SelectKnobCommand.handleTrackSelection((FireControlSurface)this.surface, this.model.getTrackBank(), isInc);
            } else if (modeManager.isActive(new Modes[]{Modes.DEVICE_PARAMS})) {
                this.handleDevicePageSelection(isInc);
            } else if (modeManager.isActive(new Modes[]{Modes.USER})) {
                this.handleUserPageSelection(isInc);
            }
            return;
        }
        if (((FireControlSurface)this.surface).isPressed(ButtonID.DRUM)) {
            double amount;
            ((FireControlSurface)this.surface).setTriggerConsumed(ButtonID.DRUM);
            ITransport transport = this.model.getTransport();
            double d = amount = ((FireControlSurface)this.surface).isPressed(ButtonID.SELECT) ? 10.0 : 1.0;
            if (((FireControlSurface)this.surface).isPressed(ButtonID.SHIFT)) {
                amount /= 100.0;
            }
            if (this.model.getValueChanger().calcKnobChange(value) < 0.0) {
                amount *= -1.0;
            }
            transport.setTempo(transport.getTempo() + amount);
            this.mvHelper.notifyTempo();
            return;
        }
        if (((FireControlSurface)this.surface).isPressed(ButtonID.METRONOME)) {
            ((FireControlSurface)this.surface).setTriggerConsumed(ButtonID.METRONOME);
            this.handlePlayPosition(value);
            return;
        }
        if (((FireConfiguration)((FireControlSurface)this.surface).getConfiguration()).isControlLastParam()) {
            Optional<IFocusedParameter> parameterOpt = this.model.getFocusedParameter();
            if (parameterOpt.isPresent() && parameterOpt.get().doesExist()) {
                double changeValue = this.model.getValueChanger().calcKnobChange(value);
                parameterOpt.get().inc(changeValue * 6.0);
            }
            return;
        }
        IView activeView = (IView)((FireControlSurface)this.surface).getViewManager().getActive();
        if (activeView instanceof IFireView) {
            IFireView fireView = (IFireView)((Object)activeView);
            fireView.onSelectKnobValue(value);
        }
    }

    private void checkUntouch(int index) {
        ModeManager modeManager = ((FireControlSurface)this.surface).getModeManager();
        if (modeManager.isActive(new Modes[]{Modes.NOTE})) {
            this.timeout.delay(() -> ((IMode)modeManager.get(Modes.NOTE)).onKnobTouch(index, false));
        }
    }

    private void handleDevicePageSelection(boolean isInc) {
        if (!this.model.hasSelectedDevice()) {
            return;
        }
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        if (isInc) {
            if (((FireControlSurface)this.surface).isShiftPressed()) {
                cursorDevice.getParameterBank().selectNextItem();
            } else {
                cursorDevice.selectNext();
            }
        } else if (((FireControlSurface)this.surface).isShiftPressed()) {
            cursorDevice.getParameterBank().selectPreviousItem();
        } else {
            cursorDevice.selectPrevious();
        }
    }

    private void handleUserPageSelection(boolean isInc) {
        FireUserMode userMode = (FireUserMode)((FireControlSurface)this.surface).getModeManager().get(Modes.USER);
        if (isInc) {
            if (((FireControlSurface)this.surface).isShiftPressed()) {
                userMode.selectNextItem();
            } else {
                userMode.setMode(false);
            }
        } else if (((FireControlSurface)this.surface).isShiftPressed()) {
            userMode.selectPreviousItem();
        } else {
            userMode.setMode(true);
        }
    }

    private void handlePlayPosition(int value) {
        ITransport transport = this.model.getTransport();
        transport.changePosition(this.model.getValueChanger().isIncrease(value), ((FireControlSurface)this.surface).isPressed(ButtonID.SHIFT));
        this.mvHelper.notifyPlayPosition();
    }

    public static void handleTrackSelection(FireControlSurface surface, ITrackBank trackBank, boolean isInc) {
        if (isInc) {
            if (surface.isPressed(ButtonID.SELECT)) {
                int index;
                ITrack lastItem;
                if (trackBank.canScrollPageForwards()) {
                    trackBank.selectNextPage();
                    return;
                }
                int positionOfLastItem = trackBank.getPositionOfLastItem();
                if (positionOfLastItem >= 0 && !(lastItem = (ITrack)trackBank.getItem(index = positionOfLastItem % trackBank.getPageSize())).isSelected()) {
                    lastItem.select();
                }
                return;
            }
            trackBank.selectNextItem();
            return;
        }
        if (surface.isPressed(ButtonID.SELECT)) {
            if (trackBank.canScrollPageBackwards()) {
                trackBank.selectPreviousPage();
                return;
            }
            ITrack firstItem = (ITrack)trackBank.getItem(0);
            if (!firstItem.isSelected()) {
                firstItem.select();
            }
            return;
        }
        trackBank.selectPreviousItem();
    }
}

