/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.apcmini.controller;

import de.mossgrabers.controller.akai.apcmini.APCminiConfiguration;
import de.mossgrabers.controller.akai.apcmini.definition.IAPCminiControllerDefinition;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.grid.PadGridImpl;
import de.mossgrabers.framework.daw.midi.IMidiOutput;

public class APCminiPadGrid
extends PadGridImpl {
    private final IAPCminiControllerDefinition definition;
    private final APCminiConfiguration configuration;

    public APCminiPadGrid(ColorManager colorManager, IMidiOutput output, APCminiConfiguration configuration, IAPCminiControllerDefinition definition) {
        super(colorManager, output);
        this.definition = definition;
        this.configuration = configuration;
    }

    @Override
    protected void sendNoteState(int channel, int note, int color) {
        int chn = channel;
        if (this.definition.hasBrightness()) {
            chn += this.configuration.getPadBrightness();
        }
        this.output.sendNoteEx(chn, note, color);
    }

    @Override
    protected void sendBlinkState(int channel, int note, int blinkColor, boolean fast) {
    }

    @Override
    public int translateToGrid(int note) {
        return note + 36;
    }

    @Override
    public int[] translateToController(int note) {
        return new int[]{0, note - 36};
    }
}

