/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.apc.view;

import de.mossgrabers.controller.akai.apc.APCConfiguration;
import de.mossgrabers.controller.akai.apc.controller.APCControlSurface;
import de.mossgrabers.controller.akai.apc.mode.NoteMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.clip.StepState;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.sequencer.AbstractNoteSequencerView;

public class SequencerView
extends AbstractNoteSequencerView<APCControlSurface, APCConfiguration> {
    public SequencerView(APCControlSurface surface, IModel model) {
        super("Sequencer", surface, model, surface.isMkII());
        this.numDisplayRows = 5;
        this.numSequencerRows = 4;
    }

    @Override
    protected void handleSequencerArea(int index, int x, int y, int velocity) {
        if (!this.isActive()) {
            return;
        }
        ModeManager modeManager = ((APCControlSurface)this.surface).getModeManager();
        if (velocity > 0) {
            NotePosition notePosition;
            INoteClip cursorClip = this.getClip();
            StepState state = cursorClip.getStep(notePosition = new NotePosition(this.configuration.getMidiEditChannel(), x, this.keyManager.map(y))).getState();
            if (state == StepState.START) {
                NoteMode noteMode = (NoteMode)modeManager.get(Modes.NOTE);
                noteMode.setValues(cursorClip, notePosition);
                modeManager.setActive(Modes.NOTE);
            }
        } else {
            if (modeManager.isActive(new Modes[]{Modes.NOTE})) {
                modeManager.restore();
            }
            if (this.isNoteEdited) {
                this.isNoteEdited = false;
                return;
            }
        }
        super.handleSequencerArea(index, x, y, velocity);
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (!ButtonID.isSceneButton(buttonID) || event != ButtonEvent.DOWN || !this.isActive()) {
            return;
        }
        switch (buttonID) {
            case SCENE1: {
                this.scales.nextScale();
                this.notifyScale();
                break;
            }
            case SCENE2: {
                this.scales.prevScale();
                this.notifyScale();
                break;
            }
            case SCENE3: {
                this.scales.toggleChromatic();
                boolean isChromatic = this.scales.isChromatic();
                ((APCConfiguration)((APCControlSurface)this.surface).getConfiguration()).setScaleInKey(!isChromatic);
                ((APCControlSurface)this.surface).getDisplay().notify(isChromatic ? "Chromatic" : "In Key");
                break;
            }
            case SCENE4: {
                this.onOctaveUp(event);
                break;
            }
            case SCENE5: {
                this.onOctaveDown(event);
                break;
            }
        }
        this.updateNoteMapping();
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        if (buttonID == ButtonID.SCENE3) {
            return "BUTTON_STATE_OFF";
        }
        return this.isActive() ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF";
    }

    @Override
    public void updateNoteMapping() {
        super.updateNoteMapping();
        this.updateScale();
    }

    @Override
    protected boolean handleSequencerAreaButtonCombinations(INoteClip clip, NotePosition notePosition, int row, int velocity) {
        boolean isUpPressed = ((APCControlSurface)this.surface).isPressed(ButtonID.ARROW_UP);
        if (isUpPressed || ((APCControlSurface)this.surface).isPressed(ButtonID.ARROW_DOWN)) {
            ((APCControlSurface)this.surface).setTriggerConsumed(isUpPressed ? ButtonID.ARROW_UP : ButtonID.ARROW_DOWN);
            if (velocity > 0) {
                this.handleSequencerAreaRepeatOperator(clip, notePosition, velocity, isUpPressed);
            }
            return true;
        }
        return super.handleSequencerAreaButtonCombinations(clip, notePosition, row, velocity);
    }

    private void notifyScale() {
        String name = this.scales.getScale().getName();
        ((APCConfiguration)((APCControlSurface)this.surface).getConfiguration()).setScale(name);
        ((APCControlSurface)this.surface).getDisplay().notify(name);
    }
}

