/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode.device;

import de.mossgrabers.controller.ableton.push.command.continuous.IPush3Encoder;
import de.mossgrabers.controller.ableton.push.controller.Push1Display;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.BaseMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.Capability;
import de.mossgrabers.framework.daw.data.IBrowserColumn;
import de.mossgrabers.framework.daw.data.IBrowserColumnItem;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;
import de.mossgrabers.framework.view.Views;
import de.mossgrabers.framework.view.sequencer.AbstractDrumView;
import java.util.Optional;

public class DeviceBrowserMode
extends BaseMode<IItem>
implements IPush3Encoder {
    private static final int SELECTION_OFF = 0;
    private static final int SELECTION_PRESET = 1;
    private static final int SELECTION_FILTER = 2;
    private int selectionMode = 0;
    private int filterColumn = -1;

    public DeviceBrowserMode(PushControlSurface surface, IModel model) {
        super("Browser", surface, model);
    }

    @Override
    public void onDeactivate() {
        super.onDeactivate();
        this.model.getBrowser().stopBrowsing(true);
        this.selectionMode = 0;
        this.filterColumn = -1;
    }

    public void changeSelectedColumnValue(int value) {
        int index = this.filterColumn == -1 ? 7 : this.filterColumn;
        this.changeValue(index, value);
    }

    public void resetFilterColumn() {
        this.filterColumn = -1;
    }

    @Override
    public void onKnobValue(int index, int value) {
        if (!this.isKnobTouched(index)) {
            return;
        }
        if (this.increaseKnobMovement()) {
            this.changeValue(index, value);
        }
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        if (this.isAnyKnobTouched() && !this.isKnobTouched(index)) {
            return;
        }
        this.setTouchedKnob(index, isTouched);
        if (isTouched) {
            if (((PushControlSurface)this.surface).isDeletePressed()) {
                ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.DELETE);
                Optional<IBrowserColumn> fc = this.getFilterColumn(index);
                if (fc.isPresent() && fc.get().doesExist()) {
                    this.model.getBrowser().resetFilterColumn(fc.get().getIndex());
                }
                return;
            }
        } else {
            this.selectionMode = 0;
            return;
        }
        if (index == 7) {
            this.selectionMode = 1;
            this.filterColumn = -1;
        } else {
            Optional<IBrowserColumn> fc = this.getFilterColumn(index);
            if (fc.isPresent() && fc.get().doesExist()) {
                this.selectionMode = 2;
                this.filterColumn = fc.get().getIndex();
            }
        }
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (((PushControlSurface)this.surface).isShiftPressed() && index == 7) {
            this.model.getBrowser().togglePreviewEnabled();
            return;
        }
        if (this.isPushModern) {
            this.selectNext(index, 1);
        } else {
            this.selectPrevious(index, 1);
        }
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (this.isPushModern) {
            this.selectPrevious(index, 1);
        } else {
            this.selectNext(index, 1);
        }
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        IBrowser browser = this.model.getBrowser();
        if (!browser.isActive()) {
            return;
        }
        switch (this.selectionMode) {
            case 0: {
                Object selectedContentType = browser.getSelectedContentType();
                if (this.filterColumn == -1) {
                    selectedContentType = Push1Display.SELECT_ARROW + (String)selectedContentType;
                }
                display.setCell(0, 7, (String)selectedContentType);
                display.setBlock(2, 2, "Selection:");
                String selectedResult = browser.getSelectedResult();
                selectedResult = selectedResult == null || selectedResult.isBlank() ? "None" : StringUtils.shortenAndFixASCII(selectedResult, 18);
                String[] infoText = browser.getInfoText().split(":");
                infoText = new String[]{infoText[0] + ":", infoText.length == 1 ? "" : infoText[1].trim()};
                String info1 = infoText[0].length() > 17 ? infoText[0].substring(0, 17) : infoText[0];
                String info2 = infoText[0].length() > 17 ? infoText[0].substring(17, infoText[0].length()) : "";
                display.setBlock(2, 0, info1).setBlock(2, 1, info2);
                info1 = infoText[1].length() > 17 ? infoText[1].substring(0, 17) : infoText[1];
                info2 = infoText[1].length() > 17 ? infoText[1].substring(17, infoText[1].length()) : "";
                display.setBlock(3, 0, info1).setBlock(3, 1, info2);
                String sel1 = selectedResult.length() > 17 ? selectedResult.substring(0, 17) : selectedResult;
                String sel2 = selectedResult.length() > 17 ? selectedResult.substring(17, selectedResult.length()) : "";
                display.setBlock(3, 2, sel1).setCell(3, 6, sel2);
                if (this.model.getHost().supports(Capability.HAS_BROWSER_PREVIEW)) {
                    display.setCell(2, 7, "Preview:");
                    display.setCell(3, 7, browser.isPreviewEnabled() ? "On" : "Off");
                }
                for (int i = 0; i < 7; ++i) {
                    Object name;
                    Optional<IBrowserColumn> column = this.getFilterColumn(i);
                    Object object = name = column.isEmpty() ? "" : StringUtils.shortenAndFixASCII(column.get().getName(), 8);
                    if (i == this.filterColumn) {
                        name = Push1Display.SELECT_ARROW + (String)name;
                    }
                    display.setCell(0, i, (String)name).setCell(1, i, DeviceBrowserMode.getColumnName(column));
                }
                break;
            }
            case 1: {
                IBrowserColumnItem[] results = browser.getResultColumnItems();
                if (!results[0].doesExist()) {
                    display.clear().setBlock(1, 1, "       No results").setBlock(1, 2, "available...").allDone();
                    return;
                }
                for (int i = 0; i < 16; ++i) {
                    if (i < results.length) {
                        display.setBlock(i % 4, i / 4, (results[i].isSelected() ? Push1Display.SELECT_ARROW : " ") + StringUtils.shortenAndFixASCII(results[i].getName(), 16));
                        continue;
                    }
                    display.setBlock(i % 4, i / 4, "");
                }
                break;
            }
            case 2: {
                IBrowserColumnItem[] items = browser.getFilterColumn(this.filterColumn).getItems();
                for (int i = 0; i < 16; ++i) {
                    String text = (items[i].isSelected() ? Push1Display.SELECT_ARROW : " ") + StringUtils.shortenAndFixASCII(items[i].getName(), 18) + "                ";
                    if (!items[i].getName().isEmpty()) {
                        String hitStr = "(" + items[i].getHitCount() + ")";
                        text = text.substring(0, 17 - hitStr.length()) + hitStr;
                    }
                    display.setBlock(i % 4, i / 4, text);
                }
                break;
            }
        }
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        IBrowser browser = this.model.getBrowser();
        if (!browser.isActive()) {
            return;
        }
        switch (this.selectionMode) {
            case 0: {
                String selectedResult = browser.getSelectedResult();
                selectedResult = selectedResult == null || selectedResult.isBlank() ? "Selection: None" : "Selection: " + selectedResult;
                for (int i = 0; i < 7; ++i) {
                    Optional<IBrowserColumn> column = this.getFilterColumn(i);
                    String headerTopName = i == 0 ? browser.getInfoText() : "";
                    String headerBottomName = i == 0 ? selectedResult : "";
                    String menuBottomName = DeviceBrowserMode.getColumnName(column);
                    display.addOptionElement(headerTopName, column.isEmpty() ? "" : column.get().getName(), i == this.filterColumn, headerBottomName, menuBottomName, !menuBottomName.equals(" "), false);
                }
                boolean supportsPreview = this.model.getHost().supports(Capability.HAS_BROWSER_PREVIEW);
                String bottomMenu = supportsPreview ? "Preview" : "";
                ColorEx menuBottomColor = browser.isPreviewEnabled() ? ColorEx.ORANGE : ColorEx.GRAY;
                display.addOptionElement("", browser.getSelectedContentType(), this.filterColumn == -1, null, "", bottomMenu, false, supportsPreview ? menuBottomColor : null, false);
                break;
            }
            case 1: {
                IBrowserColumnItem[] results = browser.getResultColumnItems();
                if (!results[0].doesExist()) {
                    for (int i = 0; i < 8; ++i) {
                        display.addOptionElement(i == 3 ? "No results available..." : "", "", false, "", "", false, false);
                    }
                    return;
                }
                for (int i = 0; i < 8; ++i) {
                    String[] items = new String[6];
                    boolean[] selected = new boolean[6];
                    for (int item = 0; item < 6; ++item) {
                        int pos = i * 6 + item;
                        items[item] = pos < results.length ? results[pos].getName(14) : "";
                        selected[item] = pos < results.length && results[pos].isSelected();
                    }
                    display.addListElement(items, selected);
                }
                break;
            }
            case 2: {
                IBrowserColumnItem[] item = browser.getFilterColumn(this.filterColumn).getItems();
                for (int i = 0; i < 8; ++i) {
                    String[] items = new String[6];
                    boolean[] selected = new boolean[6];
                    for (int itemIndex = 0; itemIndex < 6; ++itemIndex) {
                        int pos = i * 6 + itemIndex;
                        String hitText = " (" + item[pos].getHitCount() + ")";
                        Object text = item[pos].getName(12 - hitText.length());
                        if (!((String)text).isEmpty()) {
                            text = (String)text + hitText;
                        }
                        items[itemIndex] = text;
                        selected[itemIndex] = item[pos].isSelected();
                    }
                    display.addListElement(items, selected);
                }
                break;
            }
        }
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        int index = this.isButtonRow(0, buttonID);
        if (index >= 0) {
            if (index == 7) {
                if (((PushControlSurface)this.surface).isShiftPressed() && this.model.getHost().supports(Capability.HAS_BROWSER_PREVIEW)) {
                    return this.model.getBrowser().isPreviewEnabled() ? "PUSH_ORANGE_HI" : "PUSH_ORANGE_LO";
                }
                return "BUTTON_COLOR_ON";
            }
            Optional<IBrowserColumn> col = this.getFilterColumn(index);
            return col.isPresent() && col.get().doesExist() ? "BUTTON_COLOR_ON" : "BUTTON_COLOR_OFF";
        }
        index = this.isButtonRow(1, buttonID);
        if (index >= 0) {
            if (index == 7) {
                return "BUTTON_COLOR2_ON";
            }
            Optional<IBrowserColumn> col = this.getFilterColumn(index);
            return col.isPresent() && col.get().doesExist() ? "BUTTON_COLOR2_ON" : "BUTTON_COLOR_OFF";
        }
        return "BUTTON_COLOR_OFF";
    }

    @Override
    public void selectPreviousItemPage() {
        this.resetFilterColumn();
        this.model.getBrowser().previousContentType();
    }

    @Override
    public void selectNextItemPage() {
        this.resetFilterColumn();
        this.model.getBrowser().nextContentType();
    }

    @Override
    public boolean hasPreviousItem() {
        return this.model.getBrowser().hasPreviousContentType();
    }

    @Override
    public boolean hasNextItem() {
        return this.model.getBrowser().hasNextContentType();
    }

    @Override
    public boolean hasPreviousItemPage() {
        return this.hasPreviousItem();
    }

    @Override
    public boolean hasNextItemPage() {
        return this.hasNextItem();
    }

    private Optional<IBrowserColumn> getFilterColumn(int index) {
        IBrowser browser = this.model.getBrowser();
        int column = -1;
        for (int i = 0; i < browser.getFilterColumnCount(); ++i) {
            if (++column != index) continue;
            return Optional.of(browser.getFilterColumn(i));
        }
        return Optional.empty();
    }

    private void selectNext(int index, int count) {
        block4: {
            IBrowser browser;
            block3: {
                browser = this.model.getBrowser();
                if (index >= 7) break block3;
                Optional<IBrowserColumn> fc = this.getFilterColumn(index);
                if (!fc.isPresent() || !fc.get().doesExist()) break block4;
                int fi = fc.get().getIndex();
                if (fi < 0) {
                    return;
                }
                this.filterColumn = fi;
                for (int i = 0; i < count; ++i) {
                    browser.selectNextFilterItem(this.filterColumn);
                }
                break block4;
            }
            for (int i = 0; i < count; ++i) {
                browser.selectNextResult();
            }
        }
    }

    private void selectPrevious(int index, int count) {
        block4: {
            IBrowser browser;
            block3: {
                browser = this.model.getBrowser();
                if (index >= 7) break block3;
                Optional<IBrowserColumn> fc = this.getFilterColumn(index);
                if (!fc.isPresent() || !fc.get().doesExist()) break block4;
                int fi = fc.get().getIndex();
                if (fi < 0) {
                    return;
                }
                this.filterColumn = fi;
                for (int j = 0; j < count; ++j) {
                    browser.selectPreviousFilterItem(this.filterColumn);
                }
                break block4;
            }
            for (int j = 0; j < count; ++j) {
                browser.selectPreviousResult();
            }
        }
    }

    private void changeValue(int index, int value) {
        boolean direction;
        int speed = this.model.getValueChanger().calcSteppedKnobChange(value);
        boolean bl = direction = speed > 0;
        if (((PushControlSurface)this.surface).isShiftPressed()) {
            speed *= 4;
        }
        speed = Math.abs(speed);
        if (direction) {
            this.selectNext(index, speed);
        } else {
            this.selectPrevious(index, speed);
        }
    }

    private static String getColumnName(Optional<IBrowserColumn> column) {
        if (column.isEmpty() || !column.get().doesCursorExist()) {
            return "";
        }
        IBrowserColumn browserColumn = column.get();
        return browserColumn.getCursorName().equals(browserColumn.getWildcard()) ? " " : browserColumn.getCursorName(12);
    }

    @Override
    public void encoderTurn(int value) {
        this.changeSelectedColumnValue(value);
    }

    @Override
    public void encoderPress(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        boolean commit = !((PushControlSurface)this.surface).isShiftPressed();
        this.model.getBrowser().stopBrowsing(commit);
        if (!commit) {
            return;
        }
        ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
        if (viewManager.isActive(new Views[]{Views.DRUM})) {
            ((AbstractDrumView)AbstractDrumView.class.cast(viewManager.get(Views.DRUM))).repositionBankPage();
        }
    }

    @Override
    public void encoderLeft(ButtonEvent event) {
        if (event != ButtonEvent.DOWN || this.filterColumn == 0) {
            return;
        }
        IBrowser browser = this.model.getBrowser();
        this.filterColumn = this.filterColumn == -1 ? browser.getFilterColumnCount() - 1 : --this.filterColumn;
        while (this.filterColumn > 0 && !browser.getFilterColumn(this.filterColumn).doesExist()) {
            --this.filterColumn;
        }
    }

    @Override
    public void encoderRight(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        IBrowser browser = this.model.getBrowser();
        int max = browser.getFilterColumnCount() - 1;
        do {
            if (this.filterColumn >= max) {
                this.filterColumn = -1;
                break;
            }
            ++this.filterColumn;
        } while (this.filterColumn >= max || !browser.getFilterColumn(this.filterColumn).doesExist());
    }

    @Override
    public void arrowCenter(ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            this.model.getBrowser().toggleInsertionPoint();
        }
    }
}

