/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.Push1Display;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.BaseMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.Capability;
import de.mossgrabers.framework.daw.constants.RecordQuantization;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;

public class QuantizeMode
extends BaseMode<IItem> {
    private static final String[] MENU = new String[]{"Quantize", "Groove", " ", " ", " ", " ", " ", " "};

    public QuantizeMode(PushControlSurface surface, IModel model) {
        super("Record", surface, model);
    }

    @Override
    public void onKnobValue(int index, int value) {
        if (index == 7) {
            ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).changeQuantizeAmount(value);
        }
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        if (isTouched && ((PushControlSurface)this.surface).isDeletePressed()) {
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.DELETE);
            if (index == 7) {
                ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).resetQuantizeAmount();
            }
        }
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        display.setCell(0, 0, Push1Display.SELECT_ARROW + "Quantize");
        display.setCell(0, 1, "Groove");
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        RecordQuantization recQuant = cursorTrack.doesExist() ? cursorTrack.getRecordQuantizationGrid() : RecordQuantization.RES_OFF;
        RecordQuantization[] values = RecordQuantization.values();
        display.setBlock(2, 0, "Record Quantize:");
        for (int i = 0; i < values.length; ++i) {
            display.setCell(3, i, (values[i] == recQuant ? Push1Display.SELECT_ARROW : "") + values[i].getName());
        }
        if (this.model.getHost().supports(Capability.QUANTIZE_INPUT_NOTE_LENGTH)) {
            display.setBlock(2, 2, "       Quant Note");
            display.setCell(2, 6, "Length:");
            display.setCell(3, 6, cursorTrack.doesExist() && cursorTrack.isRecordQuantizationNoteLength() ? "On" : "Off");
        }
        int quantizeAmount = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).getQuantizeAmount();
        display.setCell(0, 7, "Quant Amnt").setCell(1, 7, quantizeAmount + "%").setCell(2, 7, quantizeAmount * 1023 / 100, Format.FORMAT_VALUE);
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        RecordQuantization recQuant = cursorTrack.doesExist() ? cursorTrack.getRecordQuantizationGrid() : RecordQuantization.RES_OFF;
        RecordQuantization[] values = RecordQuantization.values();
        for (int i = 0; i < values.length; ++i) {
            display.addOptionElement("", MENU[i], i == 0, i == 0 ? "Record Quantization" : "", values[i].getName(), values[i] == recQuant, true);
        }
        if (this.model.getHost().supports(Capability.QUANTIZE_INPUT_NOTE_LENGTH)) {
            display.addOptionElement("", " ", false, null, "Quantize Note Length", "", false, null, true);
            boolean isQuantLength = cursorTrack.doesExist() && cursorTrack.isRecordQuantizationNoteLength();
            display.addOptionElement("", " ", false, "", isQuantLength ? "On" : "Off", isQuantLength, true);
        } else {
            display.addEmptyElement(true);
            display.addEmptyElement(true);
        }
        if (this.model.getHost().supports(Capability.QUANTIZE_AMOUNT)) {
            int quantizeAmount = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).getQuantizeAmount();
            display.addParameterElement(" ", false, "", (ChannelType)null, null, false, "Qunt Amnt", quantizeAmount * 1023 / 100, quantizeAmount + "%", this.isKnobTouched(0), -1);
        } else {
            display.addEmptyElement(true);
        }
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        if (!cursorTrack.doesExist()) {
            return;
        }
        switch (index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                cursorTrack.setRecordQuantizationGrid(RecordQuantization.values()[index]);
                break;
            }
            case 6: {
                cursorTrack.toggleRecordQuantizationNoteLength();
                break;
            }
        }
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        if (index == 1) {
            ((PushControlSurface)this.surface).getModeManager().setTemporary(Modes.GROOVE);
        }
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        int index = this.isButtonRow(0, buttonID);
        if (index >= 0) {
            RecordQuantization recQuant;
            RecordQuantization[] values = RecordQuantization.values();
            ICursorTrack cursorTrack = this.model.getCursorTrack();
            RecordQuantization recordQuantization = recQuant = cursorTrack.doesExist() ? cursorTrack.getRecordQuantizationGrid() : RecordQuantization.RES_OFF;
            if (index < values.length) {
                return values[index] == recQuant ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON";
            }
            if (index == 6) {
                return cursorTrack.isRecordQuantizationNoteLength() ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON";
            }
            return "BUTTON_COLOR_OFF";
        }
        index = this.isButtonRow(1, buttonID);
        if (index >= 0) {
            if (index == 0) {
                return "BUTTON_COLOR_HI";
            }
            if (index == 1) {
                return "BUTTON_COLOR_ON";
            }
            return "BUTTON_COLOR_OFF";
        }
        return "BUTTON_COLOR_OFF";
    }
}

