/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode;

import de.mossgrabers.controller.ableton.push.controller.Push1Display;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.BaseMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.GrooveParameterID;
import de.mossgrabers.framework.daw.IGroove;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.daw.data.empty.EmptyParameter;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.special.FixedParameterProvider;
import de.mossgrabers.framework.utils.ButtonEvent;

public class GrooveMode
extends BaseMode<IItem> {
    private static final String TAG_GROOVE = "Groove";
    final IParameter[] params = new IParameter[8];

    public GrooveMode(PushControlSurface surface, IModel model) {
        super(TAG_GROOVE, surface, model);
        IGroove groove = this.model.getGroove();
        this.params[2] = groove.getParameter(GrooveParameterID.SHUFFLE_AMOUNT);
        this.params[3] = groove.getParameter(GrooveParameterID.SHUFFLE_RATE);
        this.params[5] = groove.getParameter(GrooveParameterID.ACCENT_AMOUNT);
        this.params[6] = groove.getParameter(GrooveParameterID.ACCENT_PHASE);
        this.params[7] = groove.getParameter(GrooveParameterID.ACCENT_RATE);
        for (int i = 0; i < this.params.length; ++i) {
            if (this.params[i] != null) continue;
            this.params[i] = EmptyParameter.INSTANCE;
        }
        this.setParameterProvider(new FixedParameterProvider(this.params));
    }

    @Override
    public void onActivate() {
        super.onActivate();
        this.setActive(true);
    }

    @Override
    public void onDeactivate() {
        super.onDeactivate();
        this.setActive(false);
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        if (isTouched && ((PushControlSurface)this.surface).isDeletePressed()) {
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.DELETE);
            this.params[index].resetValue();
        }
        this.params[index].touchValue(isTouched);
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        if (index == 0) {
            IParameter parameter;
            parameter.setNormalizedValue((parameter = this.model.getGroove().getParameter(GrooveParameterID.ENABLED)).getValue() > 0 ? 0.0 : 1.0);
        }
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        if (index == 0) {
            ((PushControlSurface)this.surface).getModeManager().setActive(Modes.REC_ARM);
        }
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        display.setCell(0, 0, "Quantize");
        display.setCell(0, 1, Push1Display.SELECT_ARROW + TAG_GROOVE);
        IGroove groove = this.model.getGroove();
        IParameter enabledParameter = groove.getParameter(GrooveParameterID.ENABLED);
        if (enabledParameter != null) {
            display.setCell(3, 0, enabledParameter.getValue() == 0 ? "  Off" : "Enabled");
        }
        display.setCell(2, 1, "Shuffle:");
        this.displayParameter(display, GrooveParameterID.SHUFFLE_AMOUNT, 2);
        this.displayParameter(display, GrooveParameterID.SHUFFLE_RATE, 3);
        boolean hasAccent = groove.getParameter(GrooveParameterID.ACCENT_AMOUNT) != EmptyParameter.INSTANCE;
        display.setCell(2, 4, hasAccent ? " Accent:" : "");
        this.displayParameter(display, GrooveParameterID.ACCENT_AMOUNT, 5);
        this.displayParameter(display, GrooveParameterID.ACCENT_PHASE, 6);
        this.displayParameter(display, GrooveParameterID.ACCENT_RATE, 7);
    }

    private void displayParameter(ITextDisplay display, GrooveParameterID paramID, int index) {
        IParameter p = this.model.getGroove().getParameter(paramID);
        if (p == null) {
            p = EmptyParameter.INSTANCE;
        }
        if (!p.doesExist()) {
            return;
        }
        display.setCell(0, index, p.getName(8));
        display.setCell(1, index, p.getDisplayedValue(8));
        display.setCell(2, index, p.getValue(), Format.FORMAT_VALUE);
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        IGroove groove = this.model.getGroove();
        IParameter enabledParameter = groove.getParameter(GrooveParameterID.ENABLED);
        String paramText = enabledParameter == null ? "" : (enabledParameter.getValue() == 0 ? "Off" : "Enabled");
        display.addOptionElement("", "Quantize", false, null, "", paramText, enabledParameter != null && enabledParameter.getValue() > 0, null, true);
        display.addOptionElement("", TAG_GROOVE, true, null, "      Shuffle", "", false, null, true);
        this.displayParameter(display, GrooveParameterID.SHUFFLE_AMOUNT, 2);
        this.displayParameter(display, GrooveParameterID.SHUFFLE_RATE, 3);
        boolean hasAccent = groove.getParameter(GrooveParameterID.ACCENT_AMOUNT) != EmptyParameter.INSTANCE;
        display.addOptionElement("", hasAccent ? "" : " ", false, null, hasAccent ? "      Accent" : "", "", false, null, true);
        this.displayParameter(display, GrooveParameterID.ACCENT_AMOUNT, 5);
        this.displayParameter(display, GrooveParameterID.ACCENT_PHASE, 6);
        this.displayParameter(display, GrooveParameterID.ACCENT_RATE, 7);
    }

    private void displayParameter(IGraphicDisplay display, GrooveParameterID paramID, int index) {
        IParameter p = this.model.getGroove().getParameter(paramID);
        if (p == null) {
            p = EmptyParameter.INSTANCE;
        }
        display.addParameterElement(" ", false, "", (ChannelType)null, null, false, p.getName(10), p.getValue(), p.getDisplayedValue(8), this.isKnobTouched(index), -1);
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        int index = this.isButtonRow(1, buttonID);
        if (index >= 0) {
            if (index == 0) {
                return "BUTTON_COLOR_ON";
            }
            if (index == 1) {
                return "BUTTON_COLOR_HI";
            }
        } else {
            IParameter parameter;
            index = this.isButtonRow(0, buttonID);
            if (index == 0 && (parameter = this.model.getGroove().getParameter(GrooveParameterID.ENABLED)) != null) {
                return parameter.getValue() > 0 ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON";
            }
        }
        return "BUTTON_COLOR_OFF";
    }

    private void setActive(boolean enable) {
        IGroove groove = this.model.getGroove();
        groove.enableObservers(enable);
        groove.setIndication(enable);
    }
}

