/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.controller;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.PushVersion;
import de.mossgrabers.controller.ableton.push.controller.ColorPalette;
import de.mossgrabers.controller.ableton.push.controller.PushPadGrid;
import de.mossgrabers.framework.controller.AbstractControlSurface;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.controller.grid.PadGridImpl;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.DeviceInquiry;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.daw.midi.INoteInput;
import de.mossgrabers.framework.featuregroup.IExpressionView;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.scale.MPEStatus;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.List;

public class PushControlSurface
extends AbstractControlSurface<PushConfiguration> {
    private static final int[] CHROMATIC_SCALE = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    public static final List<String> PUSH_PAD_CURVES_NAME = List.of("Linear", "Log 1 (Default)", "Log 2", "Log 3", "Log 4", "Log 5");
    public static final List<String> PUSH_PAD_THRESHOLDS_NAME = List.of("-20", "-19", "-18", "-17", "-16", "-15", "-14", "-13", "-12", "-11", "-10", "-9", "-8", "-7", "-6", "-5", "-4", "-3", "-2", "-1", "0 (Default)", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20");
    public static final int PUSH_BUTTON_TAP = 3;
    public static final int PUSH_BUTTON_METRONOME = 9;
    public static final int PUSH_SMALL_KNOB1 = 14;
    public static final int PUSH_SMALL_KNOB1_PRESS = 15;
    public static final int PUSH_SMALL_KNOB2 = 15;
    public static final int PUSH_BUTTON_ROW1_1 = 20;
    public static final int PUSH_BUTTON_ROW1_2 = 21;
    public static final int PUSH_BUTTON_ROW1_3 = 22;
    public static final int PUSH_BUTTON_ROW1_4 = 23;
    public static final int PUSH_BUTTON_ROW1_5 = 24;
    public static final int PUSH_BUTTON_ROW1_6 = 25;
    public static final int PUSH_BUTTON_ROW1_7 = 26;
    public static final int PUSH_BUTTON_ROW1_8 = 27;
    public static final int PUSH_BUTTON_MASTER = 28;
    public static final int PUSH_BUTTON_STOP_CLIP = 29;
    public static final int PUSH_BUTTON_SETUP = 30;
    public static final int PUSH_BUTTON_LAYOUT = 31;
    public static final int PUSH_BUTTON_ADD = 32;
    public static final int PUSH_BUTTON_HOT_SWAP = 33;
    public static final int PUSH_BUTTON_SESSION_DISPLAY = 34;
    public static final int PUSH_BUTTON_CONVERT = 35;
    public static final int PUSH_BUTTON_SCENE1 = 36;
    public static final int PUSH_BUTTON_SCENE2 = 37;
    public static final int PUSH_BUTTON_SCENE3 = 38;
    public static final int PUSH_BUTTON_SCENE4 = 39;
    public static final int PUSH_BUTTON_SCENE5 = 40;
    public static final int PUSH_BUTTON_SCENE6 = 41;
    public static final int PUSH_BUTTON_SCENE7 = 42;
    public static final int PUSH_BUTTON_SCENE8 = 43;
    public static final int PUSH_BUTTON_LEFT = 44;
    public static final int PUSH_BUTTON_RIGHT = 45;
    public static final int PUSH_BUTTON_UP = 46;
    public static final int PUSH_BUTTON_DOWN = 47;
    public static final int PUSH_BUTTON_SELECT = 48;
    public static final int PUSH_BUTTON_SHIFT = 49;
    public static final int PUSH_BUTTON_NOTE = 50;
    public static final int PUSH_BUTTON_SESSION = 51;
    public static final int PUSH_BUTTON_ADD_EFFECT = 52;
    public static final int PUSH_BUTTON_ADD_TRACK = 53;
    public static final int PUSH_BUTTON_OCTAVE_DOWN = 54;
    public static final int PUSH_BUTTON_OCTAVE_UP = 55;
    public static final int PUSH_BUTTON_REPEAT = 56;
    public static final int PUSH_BUTTON_ACCENT = 57;
    public static final int PUSH_BUTTON_SCALES = 58;
    public static final int PUSH_BUTTON_USER_MODE = 59;
    public static final int PUSH_BUTTON_MUTE = 60;
    public static final int PUSH_BUTTON_SOLO = 61;
    public static final int PUSH_BUTTON_DEVICE_LEFT = 62;
    public static final int PUSH_BUTTON_DEVICE_RIGHT = 63;
    public static final int PUSH_FOOTSWITCH1 = 64;
    public static final int PUSH_CAPTURE_MIDI = 65;
    public static final int PUSH_FOOTSWITCH2 = 69;
    public static final int PUSH_KNOB_ENCODER = 70;
    public static final int PUSH_KNOB1 = 71;
    public static final int PUSH_KNOB2 = 72;
    public static final int PUSH_KNOB3 = 73;
    public static final int PUSH_KNOB4 = 74;
    public static final int PUSH_KNOB5 = 75;
    public static final int PUSH_KNOB6 = 76;
    public static final int PUSH_KNOB7 = 77;
    public static final int PUSH_KNOB8 = 78;
    public static final int PUSH_KNOB9 = 79;
    public static final int PUSH_BUTTON_FILES = 80;
    public static final int PUSH_BUTTON_HELP = 81;
    public static final int PUSH_BUTTON_SAVE = 82;
    public static final int PUSH_BUTTON_LOCK = 83;
    public static final int PUSH_BUTTON_PLAY = 85;
    public static final int PUSH_BUTTON_RECORD = 86;
    public static final int PUSH_BUTTON_NEW = 87;
    public static final int PUSH_BUTTON_DUPLICATE = 88;
    public static final int PUSH_BUTTON_AUTOMATION = 89;
    public static final int PUSH_BUTTON_FIXED_LENGTH = 90;
    public static final int PUSH_BUTTON_CURSOR_CENTER = 91;
    public static final int PUSH_3_BUTTON_NEW = 92;
    public static final int PUSH_ENCODER_LEFT = 93;
    public static final int PUSH_BUTTON_ENCODER = 94;
    public static final int PUSH_ENCODER_RIGHT = 95;
    public static final int PUSH_BUTTON_ROW2_1 = 102;
    public static final int PUSH_BUTTON_ROW2_2 = 103;
    public static final int PUSH_BUTTON_ROW2_3 = 104;
    public static final int PUSH_BUTTON_ROW2_4 = 105;
    public static final int PUSH_BUTTON_ROW2_5 = 106;
    public static final int PUSH_BUTTON_ROW2_6 = 107;
    public static final int PUSH_BUTTON_ROW2_7 = 108;
    public static final int PUSH_BUTTON_ROW2_8 = 109;
    public static final int PUSH_BUTTON_DEVICE = 110;
    public static final int PUSH_BUTTON_BROWSE = 111;
    public static final int PUSH_BUTTON_TOGGLE_MASTER_CUE_VOLUME = 111;
    public static final int PUSH_BUTTON_TRACK = 112;
    public static final int PUSH_BUTTON_CLIP = 113;
    public static final int PUSH_BUTTON_VOLUME = 114;
    public static final int PUSH_BUTTON_PAN_SEND = 115;
    public static final int PUSH_BUTTON_QUANTIZE = 116;
    public static final int PUSH_BUTTON_DOUBLE = 117;
    public static final int PUSH_BUTTON_DELETE = 118;
    public static final int PUSH_BUTTON_UNDO = 119;
    public static final int PUSH_KNOB1_TOUCH = 0;
    public static final int PUSH_KNOB2_TOUCH = 1;
    public static final int PUSH_KNOB3_TOUCH = 2;
    public static final int PUSH_KNOB4_TOUCH = 3;
    public static final int PUSH_KNOB5_TOUCH = 4;
    public static final int PUSH_KNOB6_TOUCH = 5;
    public static final int PUSH_KNOB7_TOUCH = 6;
    public static final int PUSH_KNOB8_TOUCH = 7;
    public static final int PUSH_KNOB9_TOUCH = 8;
    public static final int PUSH_SMALL_KNOB1_TOUCH = 10;
    public static final int PUSH_SMALL_KNOB2_TOUCH = 9;
    public static final int PUSH_RIBBON_TOUCH = 12;
    public static final int PUSH_RIBBON_PITCHBEND = 0;
    public static final int PUSH_RIBBON_VOLUME = 1;
    public static final int PUSH_RIBBON_PAN = 2;
    public static final int PUSH_RIBBON_DISCRETE = 3;
    private static final String[] PUSH_PAD_CURVES_DATA = new String[]{"00 00 00 01 08 06 0A 00 00 00 00 00 0A 0F 0C 08 00 00 00 00 00 00 00 00", "00 00 00 01 04 0C 00 08 00 00 00 01 0D 04 0C 00 00 00 00 00 0E 0A 06 00", "00 00 00 01 04 0C 00 08 00 00 00 01 0D 04 0C 00 00 00 00 00 0C 03 05 00", "00 00 00 01 08 06 0A 00 00 00 00 01 0D 04 0C 00 00 00 00 00 0C 03 05 00", "00 00 00 01 0F 0B 0D 00 00 00 00 01 0D 04 0C 00 00 00 00 00 0C 03 05 00", "00 00 00 02 02 02 0E 00 00 00 00 01 0D 04 0C 00 00 00 00 00 00 00 00 00"};
    private static final String[] PUSH_PAD_THRESHOLDS_DATA = new String[]{"00 00 00 0A 00 00 00 0A", "00 00 01 03 00 00 01 04", "00 00 01 0C 00 00 01 0E", "00 00 02 05 00 00 02 08", "00 00 02 0E 00 00 03 02", "00 00 03 07 00 00 03 0C", "00 00 04 00 00 00 04 06", "00 00 04 09 00 00 05 00", "00 00 05 02 00 00 05 0A", "00 00 05 0B 00 00 06 04", "00 00 06 04 00 00 06 0E", "00 00 06 0D 00 00 07 08", "00 00 07 06 00 00 08 02", "00 00 07 0F 00 00 08 0C", "00 00 08 08 00 00 09 06", "00 00 09 01 00 00 0A 00", "00 00 09 0A 00 00 0A 0A", "00 00 0A 03 00 00 0B 04", "00 00 0A 0C 00 00 0B 0E", "00 00 0B 05 00 00 0C 08", "00 00 0B 0E 00 00 0D 02", "00 00 0C 07 00 00 0D 0C", "00 00 0D 00 00 00 0E 06", "00 00 0D 08 00 00 0E 0F", "00 00 0E 02 00 00 0F 0A", "00 00 0E 0B 00 01 00 04", "00 00 0F 04 00 01 00 0E", "00 00 0F 0D 00 01 01 08", "00 01 00 06 00 01 02 02", "00 01 00 0F 00 01 02 0C", "00 01 01 08 00 01 03 06", "00 01 02 01 00 01 04 00", "00 01 02 0A 00 01 04 0A", "00 01 03 03 00 01 05 04", "00 01 03 0C 00 01 05 0E", "00 01 04 05 00 01 06 08", "00 01 04 0E 00 01 07 02", "00 01 05 07 00 01 07 0C", "00 01 06 00 00 01 08 06", "00 01 06 09 00 01 09 00", "00 01 07 02 00 01 09 0A"};
    private static final int[] MAXW = new int[]{1700, 1660, 1590, 1510, 1420, 1300, 1170, 1030, 860, 640, 400};
    private static final int[] PUSH2_CPMIN = new int[]{1650, 1580, 1500, 1410, 1320, 1220, 1110, 1000, 900, 800, 700};
    private static final int[] PUSH2_CPMAX = new int[]{2050, 1950, 1850, 1750, 1650, 1570, 1490, 1400, 1320, 1240, 1180};
    private static final double[] GAMMA = new double[]{0.7, 0.64, 0.58, 0.54, 0.5, 0.46, 0.43, 0.4, 0.36, 0.32, 0.25};
    private static final int[] MINV = new int[]{1, 1, 1, 1, 1, 1, 3, 6, 12, 24, 36};
    private static final int[] MAXV = new int[]{96, 102, 116, 121, 124, 127, 127, 127, 127, 127, 127};
    private static final int[] ALPHA = new int[]{90, 70, 54, 40, 28, 20, 10, -5, -25, -55, -90};
    private static final int[] TUNE_WIDTH_VALUES = new int[]{0, 4, 8, 12, 16, 20, 24, 28, 32, 48, 64, 96};
    private static final int[] SLIDE_HEIGHT_VALUES = new int[]{19, 25, 32, 39, 45, 52, 59};
    private static final String SYSEX_HEADER_TEXT_PUSH1 = "F0 47 7F 15 ";
    private static final String SYSEX_HEADER_TEXT = "F0 00 21 1D 01 01 ";
    private static final int[] SYSEX_HEADER_BYTES = new int[]{240, 0, 33, 29, 1, 1};
    private static final String SYSEX_ZERO_PADDING = " 00 00 00 00 00 00 00 00 00 00 00 00 00";
    private static final int PAD_VELOCITY_CURVE_CHUNK_SIZE = 16;
    private static final int NUM_VELOCITY_CURVE_ENTRIES = 128;
    private static final int MIN_OUT = 1;
    private static final int MAX_OUT = 127;
    private final ColorPalette colorPalette;
    private int ribbonMode = -1;
    private int ribbonValue = -1;
    private int majorVersion = -1;
    private int minorVersion = -1;
    private int buildNumber = -1;
    private int serialNumber = -1;
    private int boardRevision = -1;
    private int currentPadSensitivityPush2 = -1;
    private int currentPadGainPush2 = -1;
    private int currentPadDynamicsPush2 = -1;
    private int currentThreshold = -1;
    private int currentDrive = -1;
    private int currentCompand = -1;
    private int currentRange = -1;
    private int[] currentCurve = null;
    private final MPEStatus mpeStatus = new MPEStatus();

    public PushControlSurface(IHost host, ColorManager colorManager, PushConfiguration configuration, IMidiOutput output, IMidiInput input) {
        super(host, configuration, colorManager, output, input, configuration.getPushVersion() == PushVersion.VERSION_3 ? new PushPadGrid(colorManager, output) : new PadGridImpl(colorManager, output), 200.0, 156.0);
        this.notifyViewChange = false;
        this.colorPalette = new ColorPalette(this);
        IPadGrid iPadGrid = this.padGrid;
        if (iPadGrid instanceof PushPadGrid) {
            PushPadGrid pushPadGrid = (PushPadGrid)iPadGrid;
            pushPadGrid.setSurface(this);
        }
        this.input.setSysexCallback(this::handleSysEx);
    }

    public String getSelectedPadThreshold() {
        return PUSH_PAD_THRESHOLDS_NAME.get(((PushConfiguration)this.configuration).getPadThresholdPush1());
    }

    public String getSelectedVelocityCurve() {
        return PUSH_PAD_CURVES_NAME.get(((PushConfiguration)this.configuration).getVelocityCurve());
    }

    public void handleMPEPitchbend(int channel, int data1, int data2) {
        if (((PushConfiguration)this.configuration).isMPEEnabled()) {
            int note;
            IView view = (IView)this.viewManager.getActive();
            if (view instanceof IExpressionView && (note = this.mpeStatus.getNoteStatus(channel)) != -1) {
                Scales scales = view.getKeyManager().getScales();
                int[] intervals = scales.isChromatic() ? CHROMATIC_SCALE : scales.getScale().getIntervals();
                int bendIndex = data2 - 64;
                int value = bendIndex * 128 + (data1 >= 64 ? data1 - 127 : data1);
                int padIndex = (int)Math.round((double)value / 170.6);
                int tonic = scales.getScaleOffset();
                int noteIndex = PushControlSurface.calcNoteIndex(intervals, note, tonic);
                int linear = noteIndex + padIndex;
                int deg = Math.floorMod(linear, intervals.length);
                int oct = Math.floorDiv(linear, intervals.length);
                int semitones = 12 * oct + intervals[deg] - intervals[noteIndex];
                boolean positive = value >= 0;
                int linearNext = linear + (positive ? 1 : -1);
                int nextDeg = Math.floorMod(linearNext, intervals.length);
                int nextOct = Math.floorDiv(linearNext, intervals.length);
                int nextPrevSemitones = 12 * nextOct + intervals[nextDeg] - intervals[noteIndex];
                double diff = (double)(nextPrevSemitones - semitones) * 100.0 / 2.0;
                double residual = (double)value - (double)padIndex * 170.6;
                int cents = (int)Math.round(residual / 85.3 * diff);
                int bendRange = 24;
                double pitchSemis = (double)semitones + (double)cents / 100.0;
                double f = Math.max(-1.0, Math.min(1.0, pitchSemis / 24.0));
                int delta = (int)Math.round(8191.0 * f);
                int value14 = Math.max(0, Math.min(16383, 8192 + delta));
                int lsb = value14 & 0x7F;
                int msb = value14 >> 7 & 0x7F;
                this.input.sendRawMidiEvent(224 + channel, lsb, msb);
            }
            return;
        }
        this.input.sendRawMidiEvent(224 + channel, data1, data2);
    }

    private static int calcNoteIndex(int[] intervals, int note, int tonic) {
        int rel = Math.floorMod(note - tonic, 12);
        for (int i = 0; i < intervals.length; ++i) {
            if (intervals[i] != rel) continue;
            return i;
        }
        return 0;
    }

    @Override
    protected void internalShutdown() {
        this.setRibbonMode(0);
        this.setRibbonValue(0);
        super.internalShutdown();
    }

    @Override
    protected void handleMidi(int status, int data1, int data2) {
        if (status == 254) {
            return;
        }
        if (((PushConfiguration)this.configuration).getPushVersion() == PushVersion.VERSION_3) {
            int code = status & 0xF0;
            int channel = status & 0xF;
            if (channel == 0) {
                if (code == 176 && data1 == 123) {
                    return;
                }
            } else {
                switch (code) {
                    case 176: {
                        if (data1 != 74) break;
                        return;
                    }
                    case 128: 
                    case 144: {
                        if (!((PushConfiguration)this.configuration).isMPEEnabled()) break;
                        IView view = (IView)this.getViewManager().getActive();
                        if (view instanceof IExpressionView) {
                            boolean isNoteOn = code == 144 & data2 > 0;
                            if (!isNoteOn) {
                                this.input.sendRawMidiEvent(224 + channel, 0, 64);
                            }
                            this.mpeStatus.handleNote(channel, view.getKeyManager().getMidiNoteFromGrid(data1), isNoteOn);
                        }
                        return;
                    }
                }
            }
        }
        super.handleMidi(status, data1, data2);
    }

    public void setRibbonMode(int mode) {
        if (this.ribbonMode == mode) {
            return;
        }
        this.ribbonMode = mode;
        if (((PushConfiguration)this.configuration).isPushModern()) {
            int status = 0;
            switch (mode) {
                case 0: {
                    status = 122;
                    break;
                }
                case 1: {
                    status = 1;
                    break;
                }
                case 2: {
                    status = 17;
                    break;
                }
                case 3: {
                    status = 9;
                    break;
                }
            }
            this.sendSysex(new int[]{23, status});
        } else {
            this.sendSysExPush1("63 00 01 0" + mode);
        }
    }

    public void setRibbonValue(int value) {
        if (this.ribbonValue == value) {
            return;
        }
        this.ribbonValue = value;
        this.output.sendPitchbend(0, value);
    }

    public void sendPadSensitivityPush1() {
        this.sendSysExPush1("5D 00 20 " + PUSH_PAD_THRESHOLDS_DATA[((PushConfiguration)this.configuration).getPadThresholdPush1()] + " " + PUSH_PAD_CURVES_DATA[((PushConfiguration)this.configuration).getVelocityCurve()]);
    }

    public void sendPadSensitivityPush2() {
        this.sendPadVelocityCurvePush2();
        this.sendPadThresholdPush2();
    }

    public void sendPadSensitivityPush3() {
        int[] curve = this.createPadSensitivityCurvePush3();
        int[] data = new int[129];
        data[0] = 67;
        System.arraycopy(curve, 0, data, 1, curve.length);
        this.sendSysex(curve);
    }

    public int[] createPadSensitivityCurvePush3() {
        int offset;
        int threshold = ((PushConfiguration)this.configuration).getPadCurveThresholdPush3();
        int drive = ((PushConfiguration)this.configuration).getPadCurveDrivePush3();
        int compand = ((PushConfiguration)this.configuration).getPadCurveCompandPush3();
        int range = ((PushConfiguration)this.configuration).getPadCurveRangePush3();
        if (this.currentThreshold == threshold && this.currentDrive == drive && this.currentCompand == compand && this.currentRange == range) {
            return this.currentCurve;
        }
        this.currentThreshold = threshold;
        this.currentDrive = drive;
        this.currentCompand = compand;
        this.currentRange = range;
        int numThresholdValues = (int)Math.round((double)(Math.clamp((long)threshold, 0, 100) * 16) / 100.0);
        int numRangeValues = (int)Math.round((double)(Math.clamp((long)range, 0, 100) * 103) / 100.0);
        int numCurveValues = 128 - numThresholdValues - numRangeValues + 2;
        int[] curve = new int[128];
        for (int i = 0; i < numThresholdValues; ++i) {
            curve[i] = 1;
        }
        double g = Math.clamp(0.5 + (double)compand / 100.0, 0.01, 0.99);
        double b = Math.clamp(0.5 + (double)drive / 100.0, 0.01, 0.99);
        for (int i = 0; i < numCurveValues; ++i) {
            double x = (double)i / (double)(numCurveValues - 1);
            double y = PushControlSurface.gain(x, g);
            y = PushControlSurface.bias(y, b);
            int v = (int)Math.round(1.0 + y * 126.0);
            v = Math.clamp((long)v, 1, 127);
            if (numThresholdValues + i > 128) continue;
            curve[Math.max((int)0, (int)(numThresholdValues + i - 1))] = v;
        }
        for (int i = offset = 128 - numRangeValues; i < curve.length; ++i) {
            curve[i] = 127;
        }
        this.currentCurve = curve;
        return curve;
    }

    private static double bias(double x, double b) {
        return x / ((1.0 / b - 2.0) * (1.0 - x) + 1.0);
    }

    private static double gain(double x, double g) {
        if (x < 0.5) {
            return 0.5 * PushControlSurface.bias(2.0 * x, 1.0 - g);
        }
        return 1.0 - 0.5 * PushControlSurface.bias(2.0 - 2.0 * x, 1.0 - g);
    }

    public void sendPressureMode(boolean isPolyPressure) {
        if (((PushConfiguration)this.configuration).isPushModern()) {
            this.sendSysex("1E 0" + (isPolyPressure ? "1" : "0"));
        } else {
            this.sendSysExPush1("5C 00 01 0" + (isPolyPressure ? "0" : "1"));
        }
    }

    private void sendPadThresholdPush2() {
        int[] args = new int[9];
        args[0] = 27;
        PushControlSurface.add7L5M(args, 1, 33);
        PushControlSurface.add7L5M(args, 3, 31);
        int padSensitivity = ((PushConfiguration)this.configuration).getPadSensitivityPush2();
        PushControlSurface.add7L5M(args, 5, PUSH2_CPMIN[padSensitivity]);
        PushControlSurface.add7L5M(args, 7, PUSH2_CPMAX[padSensitivity]);
        this.sendSysex(args);
    }

    private void sendPadVelocityCurvePush2() {
        int[] velocities = this.createPadSensitivityCurvePush2();
        for (int index = 0; index < velocities.length; index += 16) {
            int[] args = new int[18];
            args[0] = 32;
            args[1] = index;
            for (int i = 0; i < 16; ++i) {
                args[i + 2] = velocities[index + i];
            }
            this.sendSysex(args);
        }
    }

    public void sendDisplayBrightness() {
        int brightness = ((PushConfiguration)this.configuration).getDisplayBrightness() * 255 / 100;
        this.sendSysex(new int[]{8, brightness & 0x7F, brightness >> 7 & 1});
    }

    public void sendLEDBrightness() {
        int brightness = ((PushConfiguration)this.configuration).getLedBrightness() * 127 / 100;
        this.sendSysex(new int[]{6, brightness});
    }

    public void sendMPEActive(boolean enable) {
        this.sendSysex(enable ? "1E 02" : "1E 01");
    }

    public void sendPerPadPitchbendActive(boolean enable) {
        this.sendSysex("26 07 08 0" + (enable ? "2" : "0") + " 00");
    }

    public void sendInTuneLocation(int inTuneLocation) {
        this.sendSysex("26 07 0E 0" + inTuneLocation + " 00");
    }

    public void sendInTuneWidth(int inTuneWidthIndex) {
        this.sendSysex("26 07 14 " + StringUtils.toHexStr(TUNE_WIDTH_VALUES[inTuneWidthIndex]) + " 00");
    }

    public void sendSlideHeight(int slideHeightIndex) {
        this.sendSysex("26 07 24 " + StringUtils.toHexStr(SLIDE_HEIGHT_VALUES[slideHeightIndex]) + " 00");
    }

    public void sendPedals() {
        boolean useCV2;
        boolean useCV1 = ((PushConfiguration)this.configuration).getPedal1() > 0;
        boolean bl = useCV2 = ((PushConfiguration)this.configuration).getPedal2() > 0;
        int value = useCV1 ? (useCV2 ? 15 : 67) : (useCV2 ? 28 : 80);
        this.sendSysex("37 26 " + StringUtils.toHexStr(value) + SYSEX_ZERO_PADDING);
    }

    public void sendPreamp1Type() {
        int preampType = ((PushConfiguration)this.configuration).getPreamp1Type();
        this.sendSysex("37 1A " + StringUtils.toHexStr(preampType) + SYSEX_ZERO_PADDING);
    }

    public void sendPreamp2Type() {
        int preampType = ((PushConfiguration)this.configuration).getPreamp2Type();
        this.sendSysex("37 1B " + StringUtils.toHexStr(preampType) + SYSEX_ZERO_PADDING);
    }

    public void sendPreamp1Gain() {
        int preampGain = (PushConfiguration.PREAMP_GAIN_OPTIONS.length - 1 - ((PushConfiguration)this.configuration).getPreamp1Gain()) * 2;
        this.sendSysex("37 02 " + StringUtils.toHexStr(preampGain) + SYSEX_ZERO_PADDING);
    }

    public void sendPreamp2Gain() {
        int preampGain = (PushConfiguration.PREAMP_GAIN_OPTIONS.length - 1 - ((PushConfiguration)this.configuration).getPreamp2Gain()) * 2;
        this.sendSysex("37 03 " + StringUtils.toHexStr(preampGain) + SYSEX_ZERO_PADDING);
    }

    public void sendOutputConfiguration() {
        int audioOutputs = ((PushConfiguration)this.configuration).getAudioOutputs();
        int value = audioOutputs == 0 ? 0 : audioOutputs + 1;
        this.sendSysex("37 11 " + StringUtils.toHexStr(value) + SYSEX_ZERO_PADDING);
    }

    public void sendSysex(int[] parameters) {
        this.output.sendSysex(SYSEX_HEADER_TEXT + StringUtils.toHexStr(parameters) + "F7");
    }

    public void sendSysex(String parameters) {
        this.output.sendSysex(SYSEX_HEADER_TEXT + parameters + " F7");
    }

    public void sendSysExPush1(String parameters) {
        this.output.sendSysex(SYSEX_HEADER_TEXT_PUSH1 + parameters + " F7");
    }

    public int[] createPadSensitivityCurvePush2() {
        int sensitivity = ((PushConfiguration)this.configuration).getPadSensitivityPush2();
        int gain = ((PushConfiguration)this.configuration).getPadGainPush2();
        int dynamics = ((PushConfiguration)this.configuration).getPadDynamicsPush2();
        if (this.currentPadSensitivityPush2 == sensitivity && this.currentPadGainPush2 == gain && this.currentPadDynamicsPush2 == dynamics) {
            return this.currentCurve;
        }
        this.currentPadSensitivityPush2 = sensitivity;
        this.currentPadGainPush2 = gain;
        this.currentPadDynamicsPush2 = dynamics;
        int minw = 160;
        int maxw = MAXW[sensitivity];
        int minv = MINV[gain];
        int maxv = MAXV[gain];
        double[] result = PushControlSurface.calculatePointsPush2(ALPHA[dynamics]);
        double p1x = result[0];
        double p1y = result[1];
        double p2x = result[2];
        double p2y = result[3];
        int[] curve = new int[128];
        int minwIndex = 5;
        int maxwIndex = maxw / 32;
        double t = 0.0;
        for (int index = 0; index < 128; ++index) {
            double velocity;
            double w = (double)index * 32.0;
            if (w <= 160.0) {
                velocity = 1.0 + ((double)minv - 1.0) * (double)index / 5.0;
            } else if (w >= (double)maxw) {
                velocity = (double)maxv + (127.0 - (double)maxv) * (double)(index - maxwIndex) / (double)(128 - maxwIndex);
            } else {
                double wnorm = (w - 160.0) / (double)(maxw - 160);
                double[] bez = PushControlSurface.bezierPush2(wnorm, t, p1x, p1y, p2x, p2y);
                double b = bez[0];
                t = bez[1];
                double velonorm = PushControlSurface.gammaFunc(b, GAMMA[gain]);
                velocity = (double)minv + velonorm * (double)(maxv - minv);
            }
            curve[index] = Math.clamp(Math.round(velocity), 1, 127);
        }
        this.currentCurve = curve;
        return curve;
    }

    private static double[] bezierPush2(double x, double t, double p1x, double p1y, double p2x, double p2y) {
        double tl;
        double p0x = 0.0;
        double p0y = 0.0;
        double p3x = 1.0;
        double p3y = 1.0;
        for (tl = t; tl <= 1.0; tl += 1.0E-4) {
            double s = 1.0 - tl;
            double s2 = s * s;
            double s3 = s2 * s;
            double t2 = tl * tl;
            double t3 = t2 * tl;
            double xt = s3 * 0.0 + 3.0 * tl * s2 * p1x + 3.0 * t2 * s * p2x + t3 * 1.0;
            if (!(xt >= x)) continue;
            return new double[]{s3 * 0.0 + 3.0 * tl * s2 * p1y + 3.0 * t2 * s * p2y + t3 * 1.0, tl};
        }
        return new double[]{1.0, tl};
    }

    private static double[] calculatePointsPush2(double alpha) {
        double a1 = (225.0 - alpha) * Math.PI / 180.0;
        double a2 = (45.0 - alpha) * Math.PI / 180.0;
        double r = 0.4;
        return new double[]{0.5 + 0.4 * Math.cos(a1), 0.5 + 0.4 * Math.sin(a1), 0.5 + 0.4 * Math.cos(a2), 0.5 + 0.4 * Math.sin(a2)};
    }

    private static double gammaFunc(double x, double gamma) {
        return Math.pow(x, Math.exp(-4.0 + 8.0 * gamma));
    }

    private static void add7L5M(int[] array, int index, int value) {
        array[index] = value & 0x7F;
        array[index + 1] = value >> 7 & 0x1F;
    }

    private void handleSysEx(String data) {
        int[] byteData = StringUtils.fromHexStr(data);
        DeviceInquiry deviceInquiry = new DeviceInquiry(byteData);
        if (deviceInquiry.isValid()) {
            this.handleDeviceInquiryResponse(deviceInquiry);
            return;
        }
        if (((PushConfiguration)this.configuration).isPushModern() && PushControlSurface.isPush2Data(byteData)) {
            this.colorPalette.handleColorPaletteMessage(byteData);
        }
    }

    private static boolean isPush2Data(int[] data) {
        if (data.length + 1 < SYSEX_HEADER_BYTES.length) {
            return false;
        }
        for (int i = 0; i < SYSEX_HEADER_BYTES.length; ++i) {
            if (SYSEX_HEADER_BYTES[i] == data[i]) continue;
            return false;
        }
        return data[data.length - 1] == 247;
    }

    private void handleDeviceInquiryResponse(DeviceInquiry deviceInquiry) {
        if (((PushConfiguration)this.configuration).isPushModern()) {
            int[] unspecifiedData = deviceInquiry.getUnspecifiedData();
            if (unspecifiedData.length < 10) {
                return;
            }
            this.majorVersion = unspecifiedData[0];
            this.minorVersion = unspecifiedData[1];
            this.buildNumber = unspecifiedData[2] + (unspecifiedData[3] << 7);
            this.serialNumber = unspecifiedData[4] + (unspecifiedData[5] << 7) + (unspecifiedData[6] << 14) + (unspecifiedData[7] << 21) + (unspecifiedData[8] << 28);
            this.boardRevision = unspecifiedData[9];
        } else {
            int[] data = deviceInquiry.getData();
            if (data.length != 35) {
                return;
            }
            this.majorVersion = data[10] + data[9] * 10;
            this.minorVersion = data[12] + data[11] * 10;
            this.buildNumber = 0;
            this.serialNumber = 0;
            this.boardRevision = 0;
        }
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public int getBoardRevision() {
        return this.boardRevision;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public void updateColorPalette() {
        this.colorPalette.updatePalette();
    }

    public void updateMPE() {
        boolean mpeEnabled = this.isMPEEnabled();
        INoteInput input = this.input.getDefaultNoteInput();
        input.enableMPE(mpeEnabled);
        this.sendMPEActive(mpeEnabled);
        this.rebindGrid();
    }

    private boolean isMPEEnabled() {
        return this.getViewManager().getActive() instanceof IExpressionView && ((PushConfiguration)this.configuration).isMPEEnabled();
    }

    public void updateMPEPitchbendRange() {
        int mpePitchBendRange = ((PushConfiguration)this.configuration).getMPEPitchBendRange();
        this.input.getDefaultNoteInput().setMPEPitchBendSensitivity(mpePitchBendRange);
        this.output.sendMPEPitchbendRange(176, mpePitchBendRange);
    }
}

