/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.command.trigger;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.Capability;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;

public class VolumeCommand
extends AbstractTriggerCommand<PushControlSurface, PushConfiguration> {
    public VolumeCommand(IModel model, PushControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        Modes currentMode = (Modes)((Object)modeManager.getActiveID());
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        if (!config.isPushModern() && ((PushControlSurface)this.surface).isSelectPressed() && Modes.isLayerMode(currentMode)) {
            modeManager.setActive(Modes.DEVICE_LAYER_VOLUME);
            return;
        }
        if (Modes.VOLUME.equals((Object)currentMode)) {
            if (this.model.getHost().supports(Capability.HAS_CROSSFADER)) {
                modeManager.setActive(Modes.CROSSFADER);
            }
        } else {
            modeManager.setActive(Modes.VOLUME);
        }
    }
}

