/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.usb;

import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.usb.IHidDevice;
import de.mossgrabers.framework.usb.IUsbDevice;
import de.mossgrabers.framework.usb.IUsbEndpoint;
import de.mossgrabers.framework.usb.UsbException;
import de.mossgrabers.framework.usb.UsbMatcher;
import de.mossgrabers.reaper.framework.usb.HidDeviceImpl;
import de.mossgrabers.reaper.framework.usb.UsbEndpointImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.usb4java.Device;
import org.usb4java.DeviceDescriptor;
import org.usb4java.DeviceHandle;
import org.usb4java.DeviceList;
import org.usb4java.LibUsb;
import org.usb4java.LibUsbException;

public class UsbDeviceImpl
implements IUsbDevice {
    private final IHost host;
    private final UsbMatcher usbMatcher;
    private final List<Byte> interfaces = new ArrayList<Byte>();
    private final List<UsbEndpointImpl> endpointCache = new ArrayList<UsbEndpointImpl>();
    private DeviceHandle handle;
    private HidDeviceImpl hidDevice;

    public UsbDeviceImpl(IHost host, UsbMatcher usbMatcher) throws UsbException {
        this.host = host;
        this.usbMatcher = usbMatcher;
        if (usbMatcher.getEndpoints().isEmpty()) {
            return;
        }
        this.handle = UsbDeviceImpl.openDeviceWithVidPid(usbMatcher.getVendor(), usbMatcher.getProductID());
        if (this.handle == null) {
            throw new UsbException("USB Device not found.", new LibUsbException(-4));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        try {
            if (this.hidDevice != null) {
                this.hidDevice.close();
            }
        }
        finally {
            if (this.handle != null) {
                DeviceHandle h = this.handle;
                this.handle = null;
                this.endpointCache.forEach(UsbEndpointImpl::clear);
                for (Byte interf : this.interfaces) {
                    int result = LibUsb.releaseInterface((DeviceHandle)h, (int)interf.byteValue());
                    if (result == 0) continue;
                    this.host.error("Unable to release interface", new LibUsbException(result));
                }
                LibUsb.close((DeviceHandle)h);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DeviceHandle openDeviceWithVidPid(short vendorId, short productId) throws UsbException {
        DeviceList list = new DeviceList();
        int result = LibUsb.getDeviceList(null, (DeviceList)list);
        if (result < 0) {
            throw new UsbException("Unable to get device list.", new LibUsbException(result));
        }
        try {
            Iterator iterator = list.iterator();
            UsbException ex = null;
            while (iterator.hasNext()) {
                try {
                    DeviceHandle handle = UsbDeviceImpl.testAndOpenDevice((Device)iterator.next(), vendorId, productId);
                    if (handle == null) continue;
                    DeviceHandle deviceHandle = handle;
                    return deviceHandle;
                }
                catch (UsbException exception) {
                    ex = exception;
                }
            }
            if (ex != null) {
                throw ex;
            }
        }
        finally {
            LibUsb.freeDeviceList((DeviceList)list, (boolean)true);
        }
        return null;
    }

    private static DeviceHandle testAndOpenDevice(Device device, short vendorId, short productId) throws UsbException {
        DeviceDescriptor descriptor = new DeviceDescriptor();
        int result = LibUsb.getDeviceDescriptor((Device)device, (DeviceDescriptor)descriptor);
        if (result != 0) {
            throw new UsbException("Unable to read device descriptor.", new LibUsbException(result));
        }
        if (descriptor.idVendor() != vendorId || descriptor.idProduct() != productId) {
            return null;
        }
        DeviceHandle handle = new DeviceHandle();
        result = LibUsb.open((Device)device, (DeviceHandle)handle);
        if (result != 0) {
            throw new UsbException("Unable to open device.", new LibUsbException(result));
        }
        return handle;
    }

    @Override
    public IUsbEndpoint getEndpoint(int interfaceIndex, int endpointIndex) throws UsbException {
        if (this.handle == null) {
            return null;
        }
        List<UsbMatcher.EndpointMatcher> endpoints = this.usbMatcher.getEndpoints();
        UsbMatcher.EndpointMatcher endpointMatcher = endpoints.get(interfaceIndex);
        byte interfaceNumber = endpointMatcher.getInterfaceNumber();
        if (!this.interfaces.contains(interfaceNumber)) {
            int result = LibUsb.setAutoDetachKernelDriver((DeviceHandle)this.handle, (boolean)true);
            if (result != 0 && result != -12) {
                throw new UsbException("Unable enable auto kernel driver attach.", new LibUsbException(result));
            }
            result = LibUsb.claimInterface((DeviceHandle)this.handle, (int)interfaceNumber);
            if (result != 0) {
                this.host.error("Unable to claim interface.", new LibUsbException(result));
                return null;
            }
            this.interfaces.add(interfaceNumber);
        }
        UsbEndpointImpl endpoint = new UsbEndpointImpl(this.host, this.handle, endpointMatcher.getEndpointAddresses()[endpointIndex], endpointMatcher.getEndpointIsBulk()[endpointIndex]);
        this.endpointCache.add(endpoint);
        return endpoint;
    }

    @Override
    public Optional<IHidDevice> getHidDevice() throws UsbException {
        if (this.hidDevice == null) {
            this.hidDevice = new HidDeviceImpl(this.usbMatcher.getVendor(), this.usbMatcher.getProductID());
        }
        return Optional.ofNullable(this.hidDevice);
    }
}

