/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.configuration;

import de.mossgrabers.framework.configuration.IDoubleSetting;
import de.mossgrabers.reaper.framework.configuration.BaseValueSetting;
import de.mossgrabers.reaper.ui.utils.LogModel;
import de.mossgrabers.reaper.ui.utils.PropertiesEx;
import de.mossgrabers.reaper.ui.utils.SafeRunLater;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;
import javax.swing.JFormattedTextField;

public class DoubleSettingImpl
extends BaseValueSetting<JFormattedTextField, Double>
implements IDoubleSetting {
    private final double initialValue;
    private double value;

    public DoubleSettingImpl(LogModel logModel, PropertiesEx properties, String label, String category, double initialValue) {
        super(logModel, label, category, new JFormattedTextField(NumberFormat.getNumberInstance()));
        this.initialValue = initialValue;
        this.load(properties);
        ((JFormattedTextField)this.field).setValue(this.value);
        ((JFormattedTextField)this.field).addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                SafeRunLater.execute(DoubleSettingImpl.this.logModel, () -> {
                    try {
                        DoubleSettingImpl.this.set(Double.parseDouble(((JFormattedTextField)DoubleSettingImpl.this.field).getText()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                });
            }
        });
    }

    @Override
    public void set(Double value) {
        this.set((double)value);
    }

    @Override
    public void set(double value) {
        this.value = value;
        this.setDirty();
        this.flush();
        SafeRunLater.execute(this.logModel, () -> {
            String doubleStr;
            String v = ((JFormattedTextField)this.field).getText();
            if (!v.equals(doubleStr = Double.toString(this.value))) {
                ((JFormattedTextField)this.field).setText(doubleStr);
            }
        });
    }

    @Override
    public Double get() {
        return this.value;
    }

    @Override
    public void flush() {
        this.notifyObservers(this.value);
    }

    @Override
    public void store(PropertiesEx properties) {
        properties.put(this.getID(), Double.toString(this.value));
    }

    @Override
    public void load(PropertiesEx properties) {
        this.set(properties.getDouble(this.getID(), this.initialValue));
    }

    @Override
    public void reset() {
        this.set(this.initialValue);
    }
}

