/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper;

import de.mossgrabers.reaper.MainApp;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Controller {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)");
    private static MainApp app;

    private Controller() {
    }

    public static void startup(String iniPath, String appVersion) {
        Matcher m = VERSION_PATTERN.matcher(appVersion);
        int majorVersion = 1;
        int minorVersion = 0;
        if (m.find()) {
            majorVersion = Integer.parseInt(m.group(1));
            minorVersion = Integer.parseInt(m.group(2));
        }
        app = new MainApp(iniPath, majorVersion, minorVersion);
    }

    public static void addDevice(String name, String identifier) {
        if (app != null) {
            app.addDevice(name, identifier);
        }
    }

    public static void startInfrastructure() {
        if (app != null) {
            app.startupInfrastructure();
        }
    }

    public static void updateModel(String data) {
        if (app != null) {
            app.updateModel(data);
        }
    }

    public static void shutdown() {
        if (app != null) {
            app.exit();
        }
    }

    public static void displayWindow() {
        if (app != null) {
            app.showStage();
        }
    }

    public static void displayProjectWindow() {
        if (app != null) {
            app.showProjectWindow();
        }
    }

    public static void displayParameterWindow() {
        if (app != null) {
            app.showParameterWindow();
        }
    }

    public static void restartControllers() {
        if (app != null) {
            app.restartControllers();
        }
    }

    public static void setDefaultDocumentSettings() {
        if (app != null) {
            app.setDefaultDocumentSettings();
        }
    }

    public static String getFormattedDocumentSettings() {
        return app == null ? "" : app.getFormattedDocumentSettings();
    }

    public static void setFormattedDocumentSettings(String data) {
        if (app != null) {
            app.setFormattedDocumentSettings(data);
        }
    }

    public static void onMIDIEvent(int deviceID, byte[] message) {
        if (app != null) {
            app.onMIDIMessage(deviceID, message);
        }
    }
}

