/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.view;

import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.featuregroup.AbstractView;
import de.mossgrabers.framework.utils.KeyManager;

public class PianoViewHelper {
    private PianoViewHelper() {
    }

    public static void drawGrid(IPadGrid gridPad, IModel model, KeyManager keyManager) {
        PianoViewHelper.drawGrid(gridPad, model, keyManager, 8, 8);
    }

    public static void drawGrid(IPadGrid gridPad, IModel model, KeyManager keyManager, int rows, int columns) {
        if (!model.canSelectedTrackHoldNotes()) {
            gridPad.turnOff();
            return;
        }
        int startKey = 36;
        ColorManager colorManager = model.getColorManager();
        boolean isRecording = model.hasRecordingState();
        ICursorTrack track = model.getCursorTrack();
        int playKeyColor = colorManager.getColorIndex(isRecording ? "PLAY_VIEW_COLOR_RECORD" : "PLAY_VIEW_COLOR_PLAY");
        int whiteKeyColor = colorManager.getColorIndex("SCALE_COLOR_NOTE");
        int blackKeyColor = colorManager.getColorIndex(AbstractView.replaceOctaveColorWithTrackColor(track, "SCALE_COLOR_OCTAVE"));
        int offKeyColor = colorManager.getColorIndex("SCALE_COLOR_OFF");
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                int octaveColumn;
                int n = 36 + columns * row + column;
                int color = row % 2 == 0 ? (keyManager.isKeyPressed(n) ? playKeyColor : whiteKeyColor) : ((octaveColumn = column % 7) == 0 || octaveColumn == 3 || octaveColumn == 7 ? offKeyColor : (keyManager.isKeyPressed(n) ? playKeyColor : blackKeyColor));
                gridPad.light(n, color, -1, false);
            }
        }
    }
}

