/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.view;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.utils.ChordIdentifier;
import de.mossgrabers.framework.view.AbstractPlayView;
import java.util.ArrayList;
import java.util.List;

public class AbstractChordView<S extends IControlSurface<C>, C extends Configuration>
extends AbstractPlayView<S, C> {
    private static final int[][] CHORD_INTERVALS = new int[][]{{3, 5}, {5, 8}, {2, 5}, {4, 5}, {3, 5, 6}, {3, 5, 7}, {3, 5, 9}, {3, 5, 11}};
    private final List<Integer> currentChord = new ArrayList<Integer>();

    public AbstractChordView(String name, S surface, IModel model, boolean useTrackColor) {
        super(name, surface, model, useTrackColor);
    }

    @Override
    protected int[] getScaleMatrix() {
        return this.scales.getNoteMatrix(this.scales.getActiveChordMatrix());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onGridNote(int key, int velocity) {
        if (!this.model.canSelectedTrackHoldNotes()) {
            return;
        }
        super.onGridNote(key, velocity);
        int index = key - 36;
        int row = index / this.surface.getPadGrid().getCols();
        int note = this.keyManager.map(key);
        int[] chord = this.scales.getChord(note, CHORD_INTERVALS[row]);
        IMidiInput input = this.surface.getMidiInput();
        Object config = this.surface.getConfiguration();
        int channel = config.getMidiEditChannel();
        int vel = 0;
        if (velocity > 0) {
            vel = config.isAccentActive() ? config.getFixedAccentValue() : velocity;
        }
        for (int element : chord) {
            input.sendRawMidiEvent(144 + channel, element, vel);
        }
        List<Integer> list = this.currentChord;
        synchronized (list) {
            this.currentChord.clear();
            if (velocity > 0) {
                this.currentChord.add(note);
                for (int element : chord) {
                    this.currentChord.add(element);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getChordName() {
        List<Integer> list = this.currentChord;
        synchronized (list) {
            return ChordIdentifier.identifyChord(this.currentChord);
        }
    }
}

