/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.mode.track;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.mode.track.DefaultTrackMode;
import de.mossgrabers.framework.parameterprovider.track.SendParameterProvider;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;

public class TrackSendMode<S extends IControlSurface<C>, C extends Configuration>
extends DefaultTrackMode<S, C> {
    protected int sendIndex;

    public TrackSendMode(int sendIndex, S surface, IModel model, boolean isAbsolute) {
        this(sendIndex, surface, model, isAbsolute, (List<ContinuousID>)null);
    }

    public TrackSendMode(int sendIndex, S surface, IModel model, boolean isAbsolute, List<ContinuousID> controls) {
        this(sendIndex, surface, model, isAbsolute, controls, () -> surface.isShiftPressed());
    }

    public TrackSendMode(int sendIndex, S surface, IModel model, boolean isAbsolute, List<ContinuousID> controls, BooleanSupplier isAlternativeFunction) {
        super("Send " + (sendIndex + 1), surface, model, isAbsolute, controls, isAlternativeFunction);
        this.sendIndex = sendIndex;
        if (controls != null) {
            this.setParameterProvider(new SendParameterProvider(model, sendIndex, 0));
        }
    }

    @Override
    public void onKnobValue(int index, int value) {
        Optional<ITrack> track = this.getTrack(index);
        if (track.isEmpty()) {
            return;
        }
        ISend item = (ISend)track.get().getSendBank().getItem(this.sendIndex);
        if (this.isAbsolute) {
            item.setValue(value);
        } else {
            item.changeValue(value);
        }
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        Optional<ITrack> track = this.getTrack(index);
        if (track.isEmpty()) {
            return;
        }
        ISend item = (ISend)track.get().getSendBank().getItem(this.sendIndex);
        if (!item.doesExist()) {
            return;
        }
        if (isTouched && this.surface.isDeletePressed()) {
            this.surface.setTriggerConsumed(ButtonID.DELETE);
            item.resetValue();
        }
        item.touchValue(isTouched);
    }

    @Override
    public int getKnobValue(int index) {
        Optional<ITrack> track = this.getTrack(index);
        return track.isEmpty() ? -1 : ((ISend)track.get().getSendBank().getItem(this.sendIndex)).getValue();
    }
}

