/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.slmkiii.mode.device;

import de.mossgrabers.controller.novation.slmkiii.controller.SLMkIIIControlSurface;
import de.mossgrabers.controller.novation.slmkiii.controller.SLMkIIIDisplay;
import de.mossgrabers.controller.novation.slmkiii.mode.BaseMode;
import de.mossgrabers.controller.novation.slmkiii.mode.device.ParametersMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.daw.data.bank.IBank;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;

public abstract class AbstractParametersMode<B extends IItem>
extends BaseMode<B> {
    private static final String[] MODE_MENU = new String[]{"Devices", "Params", "", "", "", "First Ins", "Projct FX", "Track FX"};

    protected AbstractParametersMode(String name, SLMkIIIControlSurface surface, IModel model, IBank<B> bank) {
        super(name, surface, model, bank);
    }

    protected void onButtonArrowUp(int index) {
        ModeManager modeManager = ((SLMkIIIControlSurface)this.surface).getModeManager();
        switch (index) {
            case 0: {
                modeManager.setActive(Modes.DEVICE_PARAMS);
                ((ParametersMode)modeManager.get(Modes.DEVICE_PARAMS)).setShowDevices(true);
                break;
            }
            case 1: {
                modeManager.setActive(Modes.DEVICE_PARAMS);
                ((ParametersMode)modeManager.get(Modes.DEVICE_PARAMS)).setShowDevices(false);
                break;
            }
            case 5: {
                modeManager.setActive(Modes.INSTRUMENT_DEVICE_PARAMS);
                break;
            }
            case 6: {
                modeManager.setActive(Modes.USER);
                break;
            }
            case 7: {
                modeManager.setActive(Modes.TRACK_DETAILS);
                break;
            }
        }
        ((SLMkIIIControlSurface)this.surface).setTriggerConsumed(ButtonID.ARROW_UP);
    }

    protected int getButtonColorArrowUp(ButtonID buttonID) {
        ModeManager modeManager = ((SLMkIIIControlSurface)this.surface).getModeManager();
        boolean isDeviceParams = modeManager.isActive(new Modes[]{Modes.DEVICE_PARAMS});
        switch (buttonID) {
            case ROW1_1: {
                if (isDeviceParams && ((ParametersMode)modeManager.get(Modes.DEVICE_PARAMS)).isShowDevices()) {
                    return 29;
                }
                return 31;
            }
            case ROW1_2: {
                if (isDeviceParams && !((ParametersMode)modeManager.get(Modes.DEVICE_PARAMS)).isShowDevices()) {
                    return 53;
                }
                return 54;
            }
            case ROW1_6: {
                return modeManager.isActive(new Modes[]{Modes.INSTRUMENT_DEVICE_PARAMS}) ? 13 : 15;
            }
            case ROW1_7: {
                return modeManager.isActive(new Modes[]{Modes.USER}) ? 3 : 1;
            }
            case ROW1_8: {
                return modeManager.isActive(new Modes[]{Modes.TRACK_DETAILS}) ? 9 : 11;
            }
        }
        return 0;
    }

    protected void drawRow4ArrowUp(SLMkIIIDisplay d) {
        ModeManager modeManager = ((SLMkIIIControlSurface)this.surface).getModeManager();
        for (int i = 0; i < 8; ++i) {
            d.setCell(3, i, MODE_MENU[i]);
            boolean isActive = false;
            int color = 0;
            boolean isDeviceParams = modeManager.isActive(new Modes[]{Modes.DEVICE_PARAMS});
            switch (i) {
                case 0: {
                    if (isDeviceParams && ((ParametersMode)modeManager.get(Modes.DEVICE_PARAMS)).isShowDevices()) {
                        isActive = true;
                    }
                    color = 29;
                    break;
                }
                case 1: {
                    if (isDeviceParams && !((ParametersMode)modeManager.get(Modes.DEVICE_PARAMS)).isShowDevices()) {
                        isActive = true;
                    }
                    color = 53;
                    break;
                }
                case 5: {
                    isActive = modeManager.isActive(new Modes[]{Modes.INSTRUMENT_DEVICE_PARAMS});
                    color = 13;
                    break;
                }
                case 6: {
                    isActive = modeManager.isActive(new Modes[]{Modes.USER});
                    color = 3;
                    break;
                }
                case 7: {
                    isActive = modeManager.isActive(new Modes[]{Modes.TRACK_DETAILS});
                    color = 9;
                    break;
                }
            }
            d.setPropertyColor(i, 2, color);
            d.setPropertyValue(i, 1, isActive ? 1 : 0);
        }
    }
}

