/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.slmkiii.mode;

import de.mossgrabers.controller.novation.slmkiii.controller.SLMkIIIControlSurface;
import de.mossgrabers.controller.novation.slmkiii.controller.SLMkIIIDisplay;
import de.mossgrabers.controller.novation.slmkiii.mode.BaseMode;
import de.mossgrabers.controller.novation.slmkiii.view.DrumView;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;

public class SequencerResolutionMode
extends BaseMode<IItem> {
    public SequencerResolutionMode(SLMkIIIControlSurface surface, IModel model) {
        super("Sequencer Resolution", surface, model);
    }

    @Override
    public void onKnobValue(int index, int value) {
    }

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        DrumView drumView = (DrumView)((SLMkIIIControlSurface)this.surface).getViewManager().get(Views.DRUM);
        drumView.getClip().setStepLength(Resolution.getValueAt(index));
        ((SLMkIIIControlSurface)this.surface).getModeManager().restore();
    }

    @Override
    public int getKnobValue(int index) {
        return 0;
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        int index;
        DrumView drumView = (DrumView)((SLMkIIIControlSurface)this.surface).getViewManager().get(Views.DRUM);
        int match = Resolution.getMatch(drumView.getClip().getStepLength());
        return match == (index = buttonID.ordinal() - ButtonID.ROW1_1.ordinal()) ? 57 : 1;
    }

    @Override
    public void updateDisplay() {
        SLMkIIIDisplay d = ((SLMkIIIControlSurface)this.surface).getDisplay();
        d.clear();
        DrumView drumView = (DrumView)((SLMkIIIControlSurface)this.surface).getViewManager().get(Views.DRUM);
        int match = Resolution.getMatch(drumView.getClip().getStepLength());
        for (int i = 0; i < 8; ++i) {
            d.setCell(3, i, Resolution.getNameAt(i));
            d.setPropertyColor(i, 2, 57);
            d.setPropertyValue(i, 1, match == i ? 1 : 0);
        }
        d.setCell(0, 8, "Sequencer");
        d.setCell(1, 8, "Resolutin");
        this.setButtonInfo(d);
        d.allDone();
    }

    @Override
    public int getModeColor() {
        return 57;
    }
}

