/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.view;

import de.mossgrabers.controller.novation.launchpad.LaunchpadConfiguration;
import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.daw.midi.INoteRepeat;
import de.mossgrabers.framework.featuregroup.IScrollableView;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.ScrollStates;
import de.mossgrabers.framework.view.sequencer.AbstractDrumExView;
import de.mossgrabers.framework.view.sequencer.AbstractDrumView;

public class DrumView
extends AbstractDrumExView<LaunchpadControlSurface, LaunchpadConfiguration>
implements IScrollableView {
    private NotePosition noteEditPosition;

    public DrumView(LaunchpadControlSurface surface, IModel model) {
        super("Drum", surface, model, 4, 4, true);
        this.buttonSelect = ButtonID.PAD13;
        this.buttonMute = ButtonID.PAD14;
        this.buttonSolo = ButtonID.PAD15;
        this.buttonBrowse = ButtonID.PAD16;
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        int ordinal = buttonID.ordinal();
        if (ordinal < ButtonID.SCENE1.ordinal() || ordinal > ButtonID.SCENE8.ordinal()) {
            return 0;
        }
        int scene = ordinal - ButtonID.SCENE1.ordinal();
        if (ButtonID.isSceneButton(buttonID)) {
            INoteRepeat noteRepeat = ((LaunchpadControlSurface)this.surface).getMidiInput().getDefaultNoteInput().getNoteRepeat();
            if (this.noteRepeatPeriodOn) {
                int periodIndex = Resolution.getMatch(noteRepeat.getPeriod());
                return buttonID == ButtonID.get(ButtonID.SCENE1, 7 - periodIndex) ? 57 : 39;
            }
            if (this.noteRepeatLengthOn) {
                int lengthIndex = Resolution.getMatch(noteRepeat.getNoteLength());
                return buttonID == ButtonID.get(ButtonID.SCENE1, 7 - lengthIndex) ? 37 : 59;
            }
        }
        if (!this.isActive()) {
            return 0;
        }
        return scene == 7 - this.getResolutionIndex() ? 14 : 22;
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (!ButtonID.isSceneButton(buttonID) || event != ButtonEvent.DOWN || !this.isActive()) {
            return;
        }
        if (this.noteRepeatPeriodOn) {
            this.setPeriod(7 - (buttonID.ordinal() - ButtonID.SCENE1.ordinal()));
            return;
        }
        if (this.noteRepeatLengthOn) {
            this.setNoteLength(7 - (buttonID.ordinal() - ButtonID.SCENE1.ordinal()));
            return;
        }
        super.onButton(buttonID, event, velocity);
    }

    @Override
    protected void handleLoopArea(int pad, int velocity) {
        if (pad == 15) {
            if (velocity > 0) {
                this.toggleExtraButtons();
            }
            return;
        }
        super.handleLoopArea(pad, velocity);
    }

    @Override
    public void onGridNoteLongPress(int note) {
        if (!this.isActive()) {
            return;
        }
        int index = note - ((LaunchpadControlSurface)this.surface).getPadGrid().getStartNote();
        int x = index % this.numColumns;
        int y = index / this.numColumns;
        int offsetY = this.scales.getDrumOffset();
        if (y < this.playRows) {
            return;
        }
        this.noteEditPosition = new NotePosition(this.configuration.getMidiEditChannel(), this.numColumns * (this.allRows - 1 - y) + x, offsetY + this.selectedPad);
    }

    @Override
    protected void handleSequencerArea(int index, int x, int y, int offsetY, int velocity) {
        if (velocity != 0) {
            this.noteEditPosition = null;
            return;
        }
        if (this.noteEditPosition != null) {
            this.editNote(this.getClip(), this.noteEditPosition, false);
        } else {
            super.handleSequencerArea(index, x, y, offsetY, velocity);
        }
    }

    @Override
    protected boolean handleSequencerAreaButtonCombinations(INoteClip clip, NotePosition notePosition, int velocity) {
        boolean isUpPressed = ((LaunchpadControlSurface)this.surface).isPressed(ButtonID.UP);
        if (isUpPressed || ((LaunchpadControlSurface)this.surface).isPressed(ButtonID.DOWN)) {
            ((LaunchpadControlSurface)this.surface).setTriggerConsumed(isUpPressed ? ButtonID.UP : ButtonID.DOWN);
            if (velocity > 0) {
                this.handleSequencerAreaRepeatOperator(clip, notePosition, velocity, isUpPressed);
            }
            return true;
        }
        return super.handleSequencerAreaButtonCombinations(clip, notePosition, velocity);
    }

    @Override
    public void updateScrollStates(ScrollStates scrollStates) {
        ViewManager viewManager = ((LaunchpadControlSurface)this.surface).getViewManager();
        INoteClip drumClip = ((AbstractDrumView)AbstractDrumView.class.cast(viewManager.getActive())).getClip();
        scrollStates.setCanScrollLeft(drumClip.canScrollStepsBackwards());
        scrollStates.setCanScrollRight(drumClip.canScrollStepsForwards());
        scrollStates.setCanScrollUp(this.scales.canScrollDrumOctaveUp());
        scrollStates.setCanScrollDown(this.scales.canScrollDrumOctaveDown());
    }

    private void setPeriod(int index) {
        ((LaunchpadConfiguration)((LaunchpadControlSurface)this.surface).getConfiguration()).setNoteRepeatPeriod(Resolution.values()[index]);
        ((LaunchpadControlSurface)this.surface).scheduleTask(() -> ((LaunchpadControlSurface)this.surface).getDisplay().notify("Period: " + Resolution.getNameAt(index)), 100L);
    }

    private void setNoteLength(int index) {
        ((LaunchpadConfiguration)((LaunchpadControlSurface)this.surface).getConfiguration()).setNoteRepeatLength(Resolution.values()[index]);
        ((LaunchpadControlSurface)this.surface).scheduleTask(() -> ((LaunchpadControlSurface)this.surface).getDisplay().notify("Note Length: " + Resolution.getNameAt(index)), 100L);
    }
}

