/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchkey.maxi.mode;

import de.mossgrabers.controller.novation.launchkey.maxi.LaunchkeyMk3Configuration;
import de.mossgrabers.controller.novation.launchkey.maxi.controller.LaunchkeyMk3ControlSurface;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.mode.track.TrackVolumeMode;
import java.util.List;

public class LaunchkeyMk3VolumeMode
extends TrackVolumeMode<LaunchkeyMk3ControlSurface, LaunchkeyMk3Configuration> {
    private final boolean areKnobs;

    public LaunchkeyMk3VolumeMode(LaunchkeyMk3ControlSurface surface, IModel model, List<ContinuousID> controls) {
        super(surface, model, true, controls);
        this.areKnobs = controls.get(0) == ContinuousID.KNOB1;
    }

    @Override
    public void updateDisplay() {
        ITextDisplay d = ((LaunchkeyMk3ControlSurface)this.surface).getTextDisplay();
        if (this.areKnobs) {
            d.setCell(0, 0, "Volume" + this.formatPageRange(" %d - %d"));
            ICursorTrack cursorTrack = this.model.getCursorTrack();
            String trackText = cursorTrack.doesExist() ? String.format("%d: %s", cursorTrack.getPosition() + 1, cursorTrack.getName()) : "No sel. track";
            d.setCell(1, 0, trackText);
        }
        int row = this.areKnobs ? 2 : 18;
        ITrackBank tb = this.model.getCurrentTrackBank();
        for (int i = 0; i < 8; ++i) {
            ITrack t = (ITrack)tb.getItem(i);
            boolean exists = t.doesExist();
            int offset = i * 2;
            d.setCell(row + offset, 0, exists ? String.format("%d: %s", t.getPosition() + 1, t.getName()) : "No track");
            d.setCell(row + offset + 1, 0, (String)(exists ? "Vol: " + t.getVolumeStr() : ""));
        }
        if (!this.areKnobs) {
            IMasterTrack masterTrack = this.model.getMasterTrack();
            d.setCell(row + 16, 0, "Master");
            d.setCell(row + 16 + 1, 0, "Vol: " + masterTrack.getVolumeStr());
        }
        d.allDone();
    }
}

