/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.electra.one.mode;

import de.mossgrabers.controller.electra.one.controller.ElectraOneControlSurface;
import de.mossgrabers.framework.controller.color.ColorEx;
import java.util.Arrays;

class PageCache {
    private static final int NUM_ROWS = 6;
    private static final int NUM_COLS = 6;
    private static final int NUM_GROUPS = 500;
    private static final int GROUP_OFFSET = 500;
    private final int[][] ctrlValueCache = new int[6][6];
    private final String[][] ctrlValueLabelCache = new String[6][6];
    private final String[][] ctrlLabelCache = new String[6][6];
    private final ColorEx[][] ctrlColorCache = new ColorEx[6][6];
    private final Boolean[][] ctrlExistsCache = new Boolean[6][6];
    private final String[] groupCache = new String[500];
    private final int[][] currentCtrlValueCache = new int[6][6];
    private final String[][] currentCtrlValueLabelCache = new String[6][6];
    private final String[][] currentCtrlLabelCache = new String[6][6];
    private final ColorEx[][] currentCtrlColorCache = new ColorEx[6][6];
    private final Boolean[][] currentCtrlExistsCache = new Boolean[6][6];
    private final String[] currentGroupCache = new String[500];
    private final Object dataLock = new Object();
    private final ElectraOneControlSurface surface;
    private final int page;
    private boolean isDirty = false;

    public PageCache(int page, ElectraOneControlSurface surface) {
        this.page = page;
        this.surface = surface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateValue(int row, int column, int value, String label) {
        Object object = this.dataLock;
        synchronized (object) {
            if (value != this.ctrlValueCache[row][column]) {
                this.isDirty = true;
                this.ctrlValueCache[row][column] = value;
            }
            if (label != null && !label.equals(this.ctrlValueLabelCache[row][column])) {
                this.isDirty = true;
                this.ctrlValueLabelCache[row][column] = label;
            }
        }
    }

    public void updateColor(int row, int column, ColorEx color) {
        this.updateElement(row, column, null, color, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateElement(int row, int column, String label, ColorEx color, Boolean exists) {
        Object object = this.dataLock;
        synchronized (object) {
            if (label != null && !label.equals(this.ctrlLabelCache[row][column])) {
                this.isDirty = true;
                this.ctrlLabelCache[row][column] = label;
            }
            if (color != null && !color.equals(this.ctrlColorCache[row][column])) {
                this.isDirty = true;
                this.ctrlColorCache[row][column] = color;
            }
            if (exists != null && !exists.equals(this.ctrlExistsCache[row][column])) {
                this.isDirty = true;
                this.ctrlExistsCache[row][column] = exists;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGroupLabel(int groupID, String label) {
        Object object = this.dataLock;
        synchronized (object) {
            int gID = groupID - 500;
            if (label != null && !label.equals(this.groupCache[gID])) {
                this.isDirty = true;
                this.groupCache[gID] = label;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.dataLock;
        synchronized (object) {
            if (!this.isDirty) {
                return;
            }
            this.surface.setRepaintEnabled(false);
            for (int row = 0; row < 6; ++row) {
                for (int column = 0; column < 6; ++column) {
                    if (this.ctrlValueCache[row][column] != this.currentCtrlValueCache[row][column]) {
                        this.currentCtrlValueCache[row][column] = this.ctrlValueCache[row][column];
                        int midiCC = 10 + 10 * row + column;
                        this.surface.updateValue(midiCC, this.currentCtrlValueCache[row][column]);
                    }
                    if (this.ctrlValueLabelCache[row][column] == null || this.ctrlValueLabelCache[row][column].equals(this.currentCtrlValueLabelCache[row][column])) continue;
                    this.currentCtrlValueLabelCache[row][column] = this.ctrlValueLabelCache[row][column];
                    int controlID = this.getControlID(row, column);
                    this.surface.updateValueLabel(controlID, this.currentCtrlValueLabelCache[row][column]);
                }
            }
            String label = null;
            ColorEx color = null;
            Boolean exists = null;
            for (int row = 0; row < 6; ++row) {
                for (int column = 0; column < 6; ++column) {
                    if (this.ctrlLabelCache[row][column] != null && !this.ctrlLabelCache[row][column].equals(this.currentCtrlLabelCache[row][column])) {
                        this.currentCtrlLabelCache[row][column] = this.ctrlLabelCache[row][column];
                        label = this.currentCtrlLabelCache[row][column];
                    }
                    if (this.ctrlColorCache[row][column] != null && !this.ctrlColorCache[row][column].equals(this.currentCtrlColorCache[row][column])) {
                        this.currentCtrlColorCache[row][column] = this.ctrlColorCache[row][column];
                        color = this.currentCtrlColorCache[row][column];
                    }
                    if (this.ctrlExistsCache[row][column] != null && !this.ctrlExistsCache[row][column].equals(this.currentCtrlExistsCache[row][column])) {
                        this.currentCtrlExistsCache[row][column] = this.ctrlExistsCache[row][column];
                        exists = this.currentCtrlExistsCache[row][column];
                    }
                    if (label == null && color == null && exists == null) continue;
                    int controlID = this.getControlID(row, column);
                    this.surface.updateLabel(controlID, label, color, exists);
                    label = null;
                    color = null;
                    exists = null;
                }
            }
            for (int group = 0; group < 500; ++group) {
                if (this.groupCache[group] == null || this.groupCache[group].equals(this.currentGroupCache[group])) continue;
                this.currentGroupCache[group] = this.groupCache[group];
                this.surface.updateGroupLabel(500 + group, this.currentGroupCache[group]);
            }
            this.isDirty = false;
            this.surface.setRepaintEnabled(true);
        }
    }

    private int getControlID(int row, int column) {
        return this.page * 36 + 6 * row + column + 1;
    }

    public int getIndex(int controlID) {
        return (controlID - 1) % 36;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.dataLock;
        synchronized (object) {
            int n;
            Object[] row2;
            for (Object[] row2 : this.currentCtrlValueCache) {
                Arrays.fill(row2, -1);
            }
            String[][] stringArray = this.currentCtrlLabelCache;
            int n2 = stringArray.length;
            for (n = 0; n < n2; ++n) {
                row2 = stringArray[n];
                Arrays.fill(row2, null);
            }
            ColorEx[][] colorExArray = this.currentCtrlColorCache;
            n2 = colorExArray.length;
            for (n = 0; n < n2; ++n) {
                row2 = colorExArray[n];
                Arrays.fill(row2, null);
            }
            Boolean[][] booleanArray = this.currentCtrlExistsCache;
            n2 = booleanArray.length;
            for (n = 0; n < n2; ++n) {
                row2 = booleanArray[n];
                Arrays.fill(row2, null);
            }
            Arrays.fill(this.currentGroupCache, null);
        }
    }
}

