/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.apc.mode;

import de.mossgrabers.controller.akai.apc.controller.APCControlSurface;
import de.mossgrabers.controller.akai.apc.mode.BaseMode;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.device.BankParameterProvider;

public class UserMode
extends BaseMode<IParameter> {
    private final BankParameterProvider projectParameterProvider;
    private final BankParameterProvider trackParameterProvider;
    private boolean isProjectMode = true;

    public UserMode(APCControlSurface surface, IModel model) {
        super("User", surface, model, 2, model.getProject().getParameterBank());
        this.projectParameterProvider = new BankParameterProvider(model.getProject().getParameterBank());
        this.trackParameterProvider = new BankParameterProvider(model.getCursorTrack().getParameterBank());
        this.setParameterProvider(this.projectParameterProvider);
    }

    @Override
    public void selectItemPage(int page) {
        super.selectItemPage(page);
        this.displayPageName();
    }

    @Override
    public void selectPreviousItem() {
        this.model.getCurrentTrackBank().selectPreviousItem();
    }

    @Override
    public void selectNextItem() {
        this.model.getCurrentTrackBank().selectNextItem();
    }

    @Override
    public void selectNextItemPage() {
        this.model.getCurrentTrackBank().selectNextPage();
    }

    @Override
    public void selectPreviousItemPage() {
        this.model.getCurrentTrackBank().selectPreviousPage();
    }

    public boolean isPageSelected(int pageIndex) {
        IParameterBank userParameterBank = this.isProjectMode ? this.model.getProject().getParameterBank() : this.model.getCursorTrack().getParameterBank();
        return userParameterBank.getPageBank().getSelectedItemIndex() == pageIndex;
    }

    public void displayPageName() {
        if (this.isProjectMode) {
            this.mvHelper.notifySelectedProjectParameterPage();
        } else {
            this.mvHelper.notifySelectedTrackParameterPage();
        }
    }

    public void toggleMode() {
        this.isProjectMode = !this.isProjectMode;
        this.switchBanks(this.isProjectMode ? this.model.getProject().getParameterBank() : this.model.getCursorTrack().getParameterBank());
        this.setParameterProvider(this.isProjectMode ? this.projectParameterProvider : this.trackParameterProvider);
        this.bindControls();
        this.displayPageName();
    }
}

