/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.acvs.controller;

import de.mossgrabers.controller.akai.acvs.ACVSDevice;
import de.mossgrabers.controller.akai.acvs.controller.ACVSMessage;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ACVSMidiOutput
implements IMidiOutput {
    public static final int MESSAGE_ID_PING = 0;
    public static final int MESSAGE_ID_PONG = 1;
    public static final int MESSAGE_ID_TEXT = 16;
    public static final int MESSAGE_ID_COLOR = 17;
    private static final Map<Byte, ACVSDevice> ID_DEVICE_MAP = new HashMap<Byte, ACVSDevice>();
    private final byte[] pingMessage = new byte[]{-16, 71, 0, 59, 0, -9};
    private final byte[] messageHeader = new byte[]{-16, 71, 0, 59};
    private final IMidiOutput output;

    public ACVSMidiOutput(IMidiOutput output, ACVSDevice acvsDevice) {
        this.output = output;
        this.setActiveDeviceID(acvsDevice);
    }

    public Optional<ACVSMessage> getMessageContent(int[] data) {
        int contentLength = data.length - this.messageHeader.length - 1;
        if (contentLength <= 0 || data[data.length - 1] != 247) {
            return Optional.empty();
        }
        ACVSDevice acvsDevice = ACVSDevice.MPC_LIVE_ONE;
        for (int i = 0; i < this.messageHeader.length; ++i) {
            if (!(i == 3 ? (acvsDevice = ID_DEVICE_MAP.get((byte)data[i])) == null : this.messageHeader[i] != (byte)data[i])) continue;
            return Optional.empty();
        }
        int[] result = new int[contentLength - 1];
        System.arraycopy(data, this.messageHeader.length + 1, result, 0, contentLength - 1);
        return Optional.of(new ACVSMessage(acvsDevice, data[this.messageHeader.length], result));
    }

    public void sendPing() {
        this.output.sendSysex(this.pingMessage);
    }

    public void sendText(int itemID, String text) {
        byte[] textBytes = text.getBytes();
        int size = 4 + textBytes.length;
        byte[] data = new byte[size];
        data[0] = (byte)(itemID >> 8 & 0x7F);
        data[1] = (byte)(itemID & 0x7F);
        data[2] = (byte)(textBytes.length >> 8 & 0x7F);
        data[3] = (byte)(textBytes.length & 0x7F);
        System.arraycopy(textBytes, 0, data, 4, textBytes.length);
        this.sendSysex(16, data);
    }

    public void sendColor(int itemID, ColorEx color) {
        byte[] data = new byte[5];
        data[0] = (byte)(itemID >> 8 & 0x7F);
        data[1] = (byte)(itemID & 0x7F);
        int[] rgb = color.toIntRGB127();
        data[2] = (byte)rgb[0];
        data[3] = (byte)rgb[1];
        data[4] = (byte)rgb[2];
        this.sendSysex(17, data);
    }

    public void sendSysex(int messageTypeID, byte[] data) {
        int size = this.messageHeader.length + data.length + 2;
        byte[] message = new byte[size];
        System.arraycopy(this.messageHeader, 0, message, 0, this.messageHeader.length);
        message[this.messageHeader.length] = (byte)messageTypeID;
        System.arraycopy(data, 0, message, this.messageHeader.length + 1, data.length);
        message[message.length - 1] = -9;
        this.output.sendSysex(message);
    }

    @Override
    public void sendCC(int cc, int value) {
        this.output.sendCC(cc, value);
    }

    @Override
    public void sendCCEx(int channel, int cc, int value) {
        this.output.sendCCEx(channel, cc, value);
    }

    @Override
    public void sendNote(int note, int velocity) {
        this.output.sendNote(note, velocity);
    }

    @Override
    public void sendNoteEx(int channel, int note, int velocity) {
        this.output.sendNoteEx(channel, note, velocity);
    }

    @Override
    public void sendPolyphonicAftertouch(int data1, int data2) {
        this.output.sendPolyphonicAftertouch(data1, data2);
    }

    @Override
    public void sendPolyphonicAftertouch(int channel, int data1, int data2) {
        this.output.sendPolyphonicAftertouch(channel, data1, data2);
    }

    @Override
    public void sendChannelAftertouch(int data1, int data2) {
        this.output.sendChannelAftertouch(data1, data2);
    }

    @Override
    public void sendChannelAftertouch(int channel, int data1, int data2) {
        this.output.sendChannelAftertouch(channel, data1, data2);
    }

    @Override
    public void sendPitchbend(int data1, int data2) {
        this.output.sendPitchbend(data1, data2);
    }

    @Override
    public void sendPitchbend(int channel, int data1, int data2) {
        this.output.sendPitchbend(channel, data1, data2);
    }

    @Override
    public void sendProgramChange(int bankMSB, int bankLSB, int value) {
        this.output.sendProgramChange(bankMSB, bankLSB, value);
    }

    @Override
    public void sendProgramChange(int channel, int bankMSB, int bankLSB, int value) {
        this.output.sendProgramChange(channel, bankMSB, bankLSB, value);
    }

    @Override
    public void sendSysex(byte[] data) {
        this.output.sendSysex(data);
    }

    @Override
    public void sendSysex(String data) {
        this.output.sendSysex(data);
    }

    private void setActiveDeviceID(ACVSDevice acvsDevice) {
        byte id;
        this.pingMessage[3] = id = acvsDevice.getId();
        this.messageHeader[3] = id;
    }

    @Override
    public void configureMPE(int zone, int numberOfChannels) {
    }

    @Override
    public void sendMPEPitchbendRange(int zone, int range) {
    }

    static {
        for (ACVSDevice acvsDevice : ACVSDevice.values()) {
            ID_DEVICE_MAP.put(acvsDevice.getId(), acvsDevice);
        }
    }
}

