/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.view;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.AbstractView;
import de.mossgrabers.framework.utils.ButtonEvent;

public class PrgChangeView
extends AbstractView<PushControlSurface, PushConfiguration> {
    private final int[] greens;
    private final int[] yellows;
    private int bankNumber = 0;
    private int programNumber = -1;
    private boolean isToggled = false;

    public PrgChangeView(PushControlSurface surface, IModel model) {
        super("PrgChnge", surface, model);
        boolean isPush2 = ((PushConfiguration)surface.getConfiguration()).isPushModern();
        int greenHi = isPush2 ? 21 : 21;
        int green = isPush2 ? 22 : 22;
        int greenLo = isPush2 ? 23 : 23;
        int greenSpring = isPush2 ? 24 : 24;
        this.greens = new int[]{greenHi, green, greenLo, greenSpring, greenHi, green, greenLo, greenSpring};
        int yellowHi = isPush2 ? 13 : 13;
        int yellow = isPush2 ? 14 : 14;
        int yellowLo = isPush2 ? 15 : 15;
        int yellowLime = isPush2 ? 16 : 16;
        this.yellows = new int[]{yellowHi, yellow, yellowLo, yellowLime, yellowHi, yellow, yellowLo, yellowLime};
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (!ButtonID.isSceneButton(buttonID) || event != ButtonEvent.DOWN) {
            return;
        }
        int newBank = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
        if (newBank == this.bankNumber) {
            this.isToggled = !this.isToggled;
        } else {
            this.bankNumber = newBank;
            this.isToggled = false;
            ((PushControlSurface)this.surface).sendMidiEvent(176, 32, this.bankNumber);
            if (this.programNumber != -1) {
                ((PushControlSurface)this.surface).sendMidiEvent(192, this.programNumber, 0);
            }
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        boolean isPush2 = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPushModern();
        int black = isPush2 ? 0 : 0;
        int scene = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
        if (scene < 0 || scene >= 8 || this.bankNumber != scene) {
            return black;
        }
        if (this.isToggled) {
            return isPush2 ? 14 : 13;
        }
        return isPush2 ? 22 : 19;
    }

    @Override
    public void drawGrid() {
        int[] colors;
        int[] nArray = colors = this.isToggled ? this.yellows : this.greens;
        int selPad = this.isToggled ? (this.programNumber >= 64 ? this.programNumber - 64 : -1) : (this.programNumber < 64 ? this.programNumber : -1);
        IPadGrid gridPad = ((PushControlSurface)this.surface).getPadGrid();
        boolean isPush2 = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPushModern();
        int red = isPush2 ? 6 : 6;
        for (int i = 36; i < 100; ++i) {
            int pad = i - 36;
            int row = pad / 8;
            gridPad.light(i, selPad == pad ? red : colors[row], -1, false);
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity == 0) {
            return;
        }
        this.programNumber = note - 36 + (this.isToggled ? 64 : 0);
        ((PushControlSurface)this.surface).sendMidiEvent(192, this.programNumber, 0);
    }
}

