/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.view;

import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.view.PlayView;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.PianoViewHelper;

public class PianoView
extends PlayView {
    public PianoView(PushControlSurface surface, IModel model) {
        super("Piano", surface, model);
    }

    @Override
    public void drawGrid() {
        PianoViewHelper.drawGrid(((PushControlSurface)this.surface).getPadGrid(), this.model, this.keyManager);
    }

    @Override
    public void onOctaveDown(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        this.keyManager.clearPressedKeys();
        this.scales.decPianoOctave();
        this.updateNoteMapping();
        ((PushControlSurface)this.surface).getDisplay().notify(this.scales.getPianoRangeText());
    }

    @Override
    public void onOctaveUp(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        this.keyManager.clearPressedKeys();
        this.scales.incPianoOctave();
        this.updateNoteMapping();
        ((PushControlSurface)this.surface).getDisplay().notify(this.scales.getPianoRangeText());
    }

    @Override
    public void updateNoteMapping() {
        this.delayedUpdateNoteMapping(this.model.canSelectedTrackHoldNotes() ? this.scales.getPianoMatrix(8, 8) : EMPTY_TABLE);
    }

    @Override
    public boolean isOctaveUpButtonOn() {
        int octave = this.scales.getPianoOctave();
        return octave < 3;
    }

    @Override
    public boolean isOctaveDownButtonOn() {
        int octave = this.scales.getPianoOctave();
        return octave > -3;
    }
}

