/*
 * Decompiled with CFR 0.152.
 */
package org.usb4java;

import java.nio.ByteBuffer;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.usb4java.DescriptorUtils;

public final class BosDevCapabilityDescriptor {
    private long bosDevCapabilityDescriptorPointer;

    BosDevCapabilityDescriptor() {
    }

    public long getPointer() {
        return this.bosDevCapabilityDescriptorPointer;
    }

    public native byte bLength();

    public native byte bDescriptorType();

    public native byte bDevCapabilityType();

    public native ByteBuffer devCapabilityData();

    public String dump() {
        return String.format("BOS Device Capability Descriptor:%n  bLength %18d%n  bDescriptorType %10d%n  bDevCapabilityType %7s%n  devCapabilityData:%n%s%n", this.bLength() & 0xFF, this.bDescriptorType() & 0xFF, this.bDevCapabilityType() & 0xFF, DescriptorUtils.dump(this.devCapabilityData()).replaceAll("(?m)^", "    "));
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.bLength()).append(this.bDescriptorType()).append(this.bDevCapabilityType()).append((Object)this.devCapabilityData()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        BosDevCapabilityDescriptor other = (BosDevCapabilityDescriptor)obj;
        return new EqualsBuilder().append(this.bLength(), other.bLength()).append(this.bDescriptorType(), other.bDescriptorType()).append(this.bDevCapabilityType(), other.bDevCapabilityType()).append((Object)this.devCapabilityData(), (Object)other.devCapabilityData()).isEquals();
    }

    public String toString() {
        return this.dump();
    }
}

