/*
 * Decompiled with CFR 0.152.
 */
package purejavahidapi.linux;

import com.sun.jna.Native;
import java.io.IOException;
import purejavahidapi.DeviceRemovalListener;
import purejavahidapi.HidDeviceInfo;
import purejavahidapi.InputReportListener;
import purejavahidapi.linux.CLibrary;
import purejavahidapi.linux.HIDRAW;
import purejavahidapi.linux.LinuxBackend;
import purejavahidapi.linux.UdevLibrary;
import purejavahidapi.shared.SyncPoint;

public class HidDevice
extends purejavahidapi.HidDevice {
    private int m_DeviceHandle;
    private int m_NudgePipeReadHandle;
    private int m_NudgePipeWriteHandle;
    private LinuxBackend m_Backend;
    private boolean m_UsesNumberedReports;
    private Thread m_Thread;
    private SyncPoint m_SyncStart;
    private SyncPoint m_SyncShutdown;
    private boolean m_StopThread;
    private byte[] m_InputReportBytes;
    private byte[] m_OutputReportBytes;

    HidDevice(HidDeviceInfo deviceInfo, LinuxBackend backend) throws IOException {
        this.m_Backend = backend;
        this.m_HidDeviceInfo = deviceInfo;
        UdevLibrary.udev udev2 = UdevLibrary.udev_new();
        UdevLibrary.udev_device raw_dev = UdevLibrary.udev_device_new_from_syspath(udev2, this.m_HidDeviceInfo.getPath());
        String dev_path = UdevLibrary.udev_device_get_devnode(raw_dev);
        UdevLibrary.udev_unref(udev2);
        this.m_DeviceHandle = CLibrary.open(dev_path, 2);
        if (this.m_DeviceHandle <= 0) {
            throw new IOException("open() failed, errno " + Native.getLastError());
        }
        int[] pipes = new int[2];
        int piperes = CLibrary.pipe(pipes);
        if (piperes != 0) {
            throw new IOException("pipe() failed" + Native.getLastError());
        }
        this.m_NudgePipeReadHandle = pipes[0];
        this.m_NudgePipeWriteHandle = pipes[1];
        int[] desc_size = new int[1];
        UdevLibrary.hidraw_report_descriptor rpt_desc = new UdevLibrary.hidraw_report_descriptor();
        int res = CLibrary.ioctl(this.m_DeviceHandle, UdevLibrary.HIDIOCGRDESCSIZE, desc_size);
        if (res < 0) {
            throw new IOException("ioctl(...HIDIOCGRDESCSIZE..) failed");
        }
        rpt_desc.size = desc_size[0];
        res = CLibrary.ioctl(this.m_DeviceHandle, UdevLibrary.HIDIOCGRDESC, rpt_desc);
        if (res < 0) {
            throw new IOException("ioctl(...HIDIOCGRDESC..) failed");
        }
        this.m_UsesNumberedReports = HidDevice.uses_numbered_reports(rpt_desc.value, rpt_desc.size);
        this.m_InputReportBytes = new byte[4097];
        this.m_OutputReportBytes = new byte[4097];
        this.m_SyncStart = new SyncPoint(2);
        this.m_SyncShutdown = new SyncPoint(2);
        this.m_Thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    HidDevice.this.runReadOnBackground();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, this.m_HidDeviceInfo.getPath());
        this.m_Backend.addDevice(this.m_HidDeviceInfo.getDeviceId(), this);
        this.m_Open = true;
        this.m_Thread.setDaemon(true);
        this.m_Thread.start();
        this.m_SyncStart.waitAndSync();
    }

    private void runReadOnBackground() throws IOException {
        CLibrary.pollfd[] pfds = (CLibrary.pollfd[])new CLibrary.pollfd().toArray(2);
        pfds[0].fd = this.m_NudgePipeReadHandle;
        pfds[0].events = CLibrary.POLLIN;
        pfds[1].fd = this.m_DeviceHandle;
        pfds[1].events = CLibrary.POLLIN;
        this.m_SyncStart.waitAndSync();
        while (!this.m_StopThread) {
            int pollres = CLibrary.poll(pfds, 2, -1);
            if (pollres < 0) {
                throw new IOException("pipe() failed" + Native.getLastError());
            }
            if (pollres <= 0 || (pfds[1].revents & CLibrary.POLLIN) == 0) continue;
            int bytes_read = CLibrary.read(this.m_DeviceHandle, this.m_InputReportBytes, this.m_InputReportBytes.length);
            if (this.m_InputReportListener == null) continue;
            byte reportID = 0;
            if (this.m_UsesNumberedReports) {
                reportID = this.m_InputReportBytes[0];
                System.arraycopy(this.m_InputReportBytes, 1, this.m_InputReportBytes, 0, --bytes_read);
            }
            this.m_InputReportListener.onInputReport(this, reportID, this.m_InputReportBytes, bytes_read);
        }
        this.m_SyncShutdown.waitAndSync();
    }

    @Override
    public void close() {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        this.m_StopThread = true;
        CLibrary.write(this.m_NudgePipeWriteHandle, new byte[1], 1);
        this.m_Thread.interrupt();
        this.m_SyncShutdown.waitAndSync();
        CLibrary.close(this.m_DeviceHandle);
        CLibrary.close(this.m_NudgePipeWriteHandle);
        CLibrary.close(this.m_NudgePipeReadHandle);
        this.m_Backend.removeDevice(this.m_HidDeviceInfo.getDeviceId());
        this.m_Open = false;
    }

    @Override
    public synchronized int setOutputReport(byte reportID, byte[] data, int length) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        this.m_OutputReportBytes[0] = this.m_UsesNumberedReports ? reportID : (byte)0;
        System.arraycopy(data, 0, this.m_OutputReportBytes, 1, length);
        int len = CLibrary.write(this.m_DeviceHandle, this.m_OutputReportBytes, length + 1);
        if (len < 0) {
            return len;
        }
        return len - 1;
    }

    @Override
    public synchronized int setFeatureReport(byte reportId, byte[] data, int length) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        byte[] buffer = new byte[length + 1];
        buffer[0] = reportId;
        System.arraycopy(data, 0, buffer, 1, length);
        return CLibrary.ioctl(this.m_DeviceHandle, HIDRAW.HIDIOCSFEATURE(length + 1), buffer);
    }

    @Override
    public synchronized int setFeatureReport(byte[] data, int length) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        return CLibrary.ioctl(this.m_DeviceHandle, HIDRAW.HIDIOCSFEATURE(length), data);
    }

    @Override
    public synchronized void setInputReportListener(InputReportListener listener) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        this.m_InputReportListener = listener;
    }

    @Override
    public synchronized void setDeviceRemovalListener(DeviceRemovalListener listener) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        this.m_DeviceRemovalListener = listener;
    }

    @Override
    public synchronized int getFeatureReport(byte[] data, int length) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        return CLibrary.ioctl(this.m_DeviceHandle, HIDRAW.HIDIOCGFEATURE(length), data);
    }

    private static boolean uses_numbered_reports(byte[] report_descriptor, int size) {
        boolean debug = false;
        int i = 0;
        while (i < size) {
            int key_size;
            int data_len;
            int key = report_descriptor[i] & 0xFF;
            if (key == 133) {
                return true;
            }
            if ((key & 0xF0) == 240) {
                data_len = i + 1 < size ? report_descriptor[i + 1] : 0;
                key_size = 3;
            } else {
                int size_code = key & 3;
                switch (size_code) {
                    case 0: 
                    case 1: 
                    case 2: {
                        data_len = size_code;
                        break;
                    }
                    case 3: {
                        data_len = 4;
                        break;
                    }
                    default: {
                        data_len = 0;
                    }
                }
                key_size = 1;
            }
            i += data_len + key_size;
        }
        return false;
    }

    @Override
    public DeviceRemovalListener getDeviceRemovalListener() {
        return this.m_DeviceRemovalListener;
    }
}

