/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.hardware;

import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.OutputID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.hardware.IHwAbsoluteKnob;
import de.mossgrabers.framework.controller.hardware.IHwButton;
import de.mossgrabers.framework.controller.hardware.IHwControl;
import de.mossgrabers.framework.controller.hardware.IHwFader;
import de.mossgrabers.framework.controller.hardware.IHwGraphicsDisplay;
import de.mossgrabers.framework.controller.hardware.IHwLight;
import de.mossgrabers.framework.controller.hardware.IHwPianoKeyboard;
import de.mossgrabers.framework.controller.hardware.IHwRelativeKnob;
import de.mossgrabers.framework.controller.hardware.IHwSurfaceFactory;
import de.mossgrabers.framework.controller.hardware.IHwTextDisplay;
import de.mossgrabers.framework.controller.valuechanger.RelativeEncoding;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.graphics.IBitmap;
import de.mossgrabers.reaper.framework.hardware.HwAbsoluteKnobImpl;
import de.mossgrabers.reaper.framework.hardware.HwButtonImpl;
import de.mossgrabers.reaper.framework.hardware.HwFaderImpl;
import de.mossgrabers.reaper.framework.hardware.HwGraphicsDisplayImpl;
import de.mossgrabers.reaper.framework.hardware.HwLightImpl;
import de.mossgrabers.reaper.framework.hardware.HwPianoKeyboardImpl;
import de.mossgrabers.reaper.framework.hardware.HwRelativeKnobImpl;
import de.mossgrabers.reaper.framework.hardware.HwTextDisplayImpl;
import de.mossgrabers.reaper.framework.hardware.IReaperHwControl;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;

public class HwSurfaceFactoryImpl
implements IHwSurfaceFactory {
    private final IHost host;
    private final List<IReaperHwControl> controls = new ArrayList<IReaperHwControl>();
    private double width;
    private double height;
    private int lightCounter = 0;

    public HwSurfaceFactoryImpl(IHost host) {
        this.host = host;
    }

    @Override
    public IHwButton createButton(int surfaceID, ButtonID buttonID, String label) {
        HwButtonImpl button = new HwButtonImpl(buttonID.name(), this.host, label);
        this.controls.add(button);
        return button;
    }

    @Override
    public IHwLight createLight(int surfaceID, OutputID outputID, Supplier<ColorEx> supplier, Consumer<ColorEx> sendValueConsumer) {
        ++this.lightCounter;
        String id = HwSurfaceFactoryImpl.createID(surfaceID, (String)(outputID == null ? "LIGHT" + this.lightCounter : outputID.name()));
        HwLightImpl light = new HwLightImpl(id, supplier, sendValueConsumer);
        this.controls.add(light);
        return light;
    }

    @Override
    public IHwLight createLight(int surfaceID, OutputID outputID, IntSupplier supplier, IntConsumer sendValueConsumer, IntFunction<ColorEx> stateToColorFunction, IHwButton button) {
        ++this.lightCounter;
        String id = HwSurfaceFactoryImpl.createID(surfaceID, (String)(outputID == null ? "LIGHT" + this.lightCounter : outputID.name()));
        HwLightImpl light = new HwLightImpl(id, supplier, sendValueConsumer, stateToColorFunction);
        if (button == null) {
            this.controls.add(light);
        } else {
            button.addLight(light);
        }
        return light;
    }

    @Override
    public IHwFader createFader(int surfaceID, ContinuousID faderID, String label, boolean isVertical) {
        HwFaderImpl fader = new HwFaderImpl(faderID.name(), this.host, label, isVertical);
        this.controls.add(fader);
        return fader;
    }

    @Override
    public IHwAbsoluteKnob createAbsoluteKnob(int surfaceID, ContinuousID knobID, String label) {
        String id = HwSurfaceFactoryImpl.createID(surfaceID, knobID.name());
        HwAbsoluteKnobImpl knob = new HwAbsoluteKnobImpl(id, this.host, label);
        this.controls.add(knob);
        return knob;
    }

    @Override
    public IHwRelativeKnob createRelativeKnob(int surfaceID, ContinuousID knobID, String label) {
        String id = HwSurfaceFactoryImpl.createID(surfaceID, knobID.name());
        HwRelativeKnobImpl knob = new HwRelativeKnobImpl(id, this.host, label);
        this.controls.add(knob);
        return knob;
    }

    @Override
    public IHwRelativeKnob createRelativeKnob(int surfaceID, ContinuousID knobID, String label, RelativeEncoding encoding) {
        String id = HwSurfaceFactoryImpl.createID(surfaceID, knobID.name());
        HwRelativeKnobImpl knob = new HwRelativeKnobImpl(id, this.host, label, encoding);
        this.controls.add(knob);
        return knob;
    }

    @Override
    public IHwTextDisplay createTextDisplay(int surfaceID, OutputID outputID, int numLines) {
        String id = HwSurfaceFactoryImpl.createID(surfaceID, outputID.name());
        HwTextDisplayImpl display = new HwTextDisplayImpl(id, numLines);
        this.controls.add(display);
        return display;
    }

    @Override
    public IHwGraphicsDisplay createGraphicsDisplay(int surfaceID, OutputID outputID, IBitmap bitmap) {
        String id = HwSurfaceFactoryImpl.createID(surfaceID, outputID.name());
        HwGraphicsDisplayImpl display = new HwGraphicsDisplayImpl(id, bitmap);
        this.controls.add(display);
        return display;
    }

    @Override
    public IHwPianoKeyboard createPianoKeyboard(int surfaceID, int numKeys) {
        boolean octave = false;
        boolean startKeyInOctave = false;
        String id = HwSurfaceFactoryImpl.createID(surfaceID, "KEYBOARD");
        HwPianoKeyboardImpl piano = new HwPianoKeyboardImpl(id, numKeys, 0, 0);
        this.controls.add(piano);
        return piano;
    }

    @Override
    public void flush() {
        this.controls.forEach(IHwControl::update);
    }

    @Override
    public void clearCache() {
        this.controls.forEach(control -> {
            if (control instanceof IHwLight) {
                IHwLight light = (IHwLight)((Object)control);
                light.forceFlush();
            }
        });
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public List<IReaperHwControl> getControls() {
        return this.controls;
    }

    private static String createID(int surfaceID, String name) {
        return surfaceID + 1 + "_" + name;
    }

    public void setDimension(double width, double height) {
        this.width = width;
        this.height = height;
    }
}

