/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data.bank;

import de.mossgrabers.framework.daw.data.IDevice;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.bank.IParameterPageBank;
import de.mossgrabers.framework.daw.data.empty.EmptyParameter;
import de.mossgrabers.framework.observer.IParameterValueObserver;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.reaper.communication.Processor;
import de.mossgrabers.reaper.framework.daw.DataSetupEx;
import de.mossgrabers.reaper.framework.daw.data.bank.AbstractPagedBankImpl;
import de.mossgrabers.reaper.framework.daw.data.bank.ParameterPageBankImpl;
import de.mossgrabers.reaper.framework.daw.data.parameter.ParameterImpl;
import de.mossgrabers.reaper.framework.daw.data.parameter.ParameterProxy;
import de.mossgrabers.reaper.framework.daw.data.parameter.map.ParameterMap;
import de.mossgrabers.reaper.framework.daw.data.parameter.map.ParameterMapPage;
import de.mossgrabers.reaper.framework.daw.data.parameter.map.ParameterMapPageParameter;
import de.mossgrabers.reaper.framework.daw.data.parameter.map.RenamedParameter;
import de.mossgrabers.reaper.framework.device.DeviceManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ParameterBankImpl
extends AbstractPagedBankImpl<ParameterImpl, IParameter>
implements IParameterBank {
    private final Map<String, Integer> selectedDevicePages = new HashMap<String, Integer>();
    private final Processor processor;
    private final IDevice device;
    private final IParameter[] mappedParameterCache;
    private int mappedParameterCount;
    private final ParameterPageBankImpl parameterPageBank;
    private final Set<IParameterValueObserver> observers = new HashSet<IParameterValueObserver>();

    public ParameterBankImpl(DataSetupEx dataSetup, int numParams, IDevice device) {
        this(dataSetup, Processor.DEVICE, numParams, device);
    }

    public ParameterBankImpl(DataSetupEx dataSetup, Processor processor, int numParams, IDevice device) {
        super(dataSetup, numParams, EmptyParameter.INSTANCE);
        this.parameterPageBank = new ParameterPageBankImpl(numParams, this, device);
        this.processor = processor;
        this.device = device;
        if (this.device != null) {
            this.device.addNameObserver(name -> this.setBankOffset(this.selectedDevicePages.getOrDefault(name.toLowerCase(), 0)));
        }
        this.mappedParameterCache = new IParameter[this.pageSize];
        this.clearParameterCache();
    }

    @Override
    public int getItemCount() {
        return this.mappedParameterCount < 0 ? this.itemCount : this.mappedParameterCount;
    }

    public int getUnpagedItemCount() {
        return this.itemCount;
    }

    @Override
    protected void setBankOffset(int bankOffset) {
        this.bankOffset = Math.max(0, Math.min(bankOffset, this.getItemCount() - 1));
        if (this.device != null) {
            this.selectedDevicePages.put(this.device.getName().toLowerCase(), this.bankOffset);
        }
        this.refreshParameterCache();
    }

    @Override
    public IParameter getItem(int index) {
        return new ParameterProxy(this, index);
    }

    public IParameter getParameter(int index) {
        return this.mappedParameterCount < 0 ? (IParameter)super.getItem(index) : this.mappedParameterCache[index];
    }

    @Override
    protected ParameterImpl createItem(int position) {
        return new ParameterImpl(this.dataSetup, this.processor, position % this.pageSize, 0.0);
    }

    @Override
    public void scrollBackwards() {
        this.selectPreviousItem();
    }

    @Override
    public void scrollForwards() {
        this.selectNextItem();
    }

    @Override
    public void selectPreviousItem() {
        this.scrollTo(this.bankOffset - this.pageSize);
    }

    @Override
    public void selectNextItem() {
        this.scrollTo(this.bankOffset + this.pageSize);
    }

    @Override
    public void selectPreviousPage() {
        this.scrollTo(this.bankOffset - this.pageSize * this.pageSize);
    }

    @Override
    public void selectNextPage() {
        this.scrollTo(this.bankOffset + this.pageSize * this.pageSize);
    }

    @Override
    public void scrollTo(int position) {
        this.scrollTo(position, true);
    }

    @Override
    public void scrollTo(int position, boolean adjustPage) {
        if (position >= 0 && position < this.getItemCount()) {
            this.setBankOffset(adjustPage ? position / this.pageSize * this.pageSize : position);
        }
    }

    @Override
    public IParameterPageBank getPageBank() {
        return this.parameterPageBank;
    }

    @Override
    public void addValueObserver(IParameterValueObserver observer) {
        this.observers.add(observer);
    }

    public void notifyValueObservers(int paramIndex) {
        int pageSize = this.getPageSize();
        int page = paramIndex / pageSize;
        int index = paramIndex % pageSize;
        for (IParameterValueObserver observer : this.observers) {
            observer.update(page, index);
        }
    }

    public void refreshParameterCache() {
        this.updateParameterCache();
        this.parameterPageBank.updatePageCache();
        this.firePageObserver();
    }

    private void updateParameterCache() {
        int i;
        ParameterMap parameterMap = null;
        if (this.device != null) {
            String deviceName = this.device.getName();
            parameterMap = DeviceManager.get().getParameterMaps().get(deviceName.toLowerCase());
        }
        if (parameterMap == null) {
            this.clearParameterCache();
            return;
        }
        List<ParameterMapPage> pages = parameterMap.getPages();
        int page = this.bankOffset / this.pageSize;
        int numPages = pages.size();
        if (numPages == 0) {
            return;
        }
        if (page >= numPages) {
            this.setBankOffset(0);
            return;
        }
        this.mappedParameterCount = numPages * this.pageSize;
        List<ParameterMapPageParameter> parameters = pages.get(page).getParameters();
        for (i = 0; i < 8; ++i) {
            ParameterMapPageParameter parameterMapPageParameter = parameters.get(i);
            int destIndex = parameterMapPageParameter.getIndex();
            this.mappedParameterCache[i] = destIndex < 0 ? EmptyParameter.INSTANCE : new RenamedParameter((IParameter)this.getUnpagedItem(destIndex), parameterMapPageParameter.getName());
        }
        for (i = 8; i < this.pageSize; ++i) {
            this.mappedParameterCache[i] = EmptyParameter.INSTANCE;
        }
    }

    private void clearParameterCache() {
        this.mappedParameterCount = -1;
        Arrays.fill(this.mappedParameterCache, EmptyParameter.INSTANCE);
    }
}

