/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.view;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.AbstractView;

public class BrowserView<S extends IControlSurface<C>, C extends Configuration>
extends AbstractView<S, C> {
    public static final String OFF = "BROWSER_OFF";
    public static final String DISCARD = "BROWSER_DISCARD";
    public static final String CONFIRM = "BROWSER_CONFIRM";
    public static final String PLAY = "BROWSER_PLAY";
    public static final String COLUMN1 = "BROWSER_COLUMN1";
    public static final String COLUMN2 = "BROWSER_COLUMN2";
    public static final String COLUMN3 = "BROWSER_COLUMN3";
    public static final String COLUMN4 = "BROWSER_COLUMN4";
    public static final String COLUMN5 = "BROWSER_COLUMN5";
    public static final String COLUMN6 = "BROWSER_COLUMN6";
    public static final String COLUMN7 = "BROWSER_COLUMN7";
    public static final String COLUMN8 = "BROWSER_COLUMN8";
    private static final String[] COLUMNS = new String[]{"BROWSER_COLUMN1", "BROWSER_COLUMN2", "BROWSER_COLUMN3", "BROWSER_COLUMN4", "BROWSER_COLUMN5", "BROWSER_COLUMN6", "BROWSER_COLUMN7", "BROWSER_COLUMN8"};
    private static final int[] COLUMN_ORDER = new int[]{0, 1, 2, 3, 4, 5};

    public BrowserView(S surface, IModel model) {
        super("Browser", surface, model);
    }

    @Override
    public void drawGrid() {
        int i;
        IPadGrid padGrid = this.surface.getPadGrid();
        padGrid.light(36, DISCARD);
        padGrid.light(37, OFF);
        for (i = 38; i < 42; ++i) {
            padGrid.light(i, PLAY);
        }
        padGrid.light(42, OFF);
        padGrid.light(43, CONFIRM);
        for (i = 44; i < 52; ++i) {
            padGrid.light(i, OFF);
        }
        for (i = 52; i < 60; ++i) {
            padGrid.light(i, COLUMNS[i - 52]);
        }
        for (i = 60; i < 68; ++i) {
            padGrid.light(i, COLUMNS[i - 60]);
        }
        for (i = 68; i < 76; ++i) {
            padGrid.light(i, COLUMNS[i - 68]);
        }
        for (i = 76; i < 84; ++i) {
            padGrid.light(i, COLUMNS[i - 76]);
        }
        for (i = 84; i < 100; ++i) {
            padGrid.light(i, OFF);
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        IBrowser browser = this.model.getBrowser();
        if (!browser.isActive()) {
            return;
        }
        switch (note) {
            case 36: {
                if (velocity == 0) {
                    return;
                }
                browser.stopBrowsing(false);
                this.surface.getViewManager().restore();
                break;
            }
            case 43: {
                if (velocity == 0) {
                    return;
                }
                browser.stopBrowsing(true);
                this.surface.getViewManager().restore();
                break;
            }
            case 38: {
                this.surface.sendMidiEvent(144, 48, velocity);
                break;
            }
            case 39: {
                this.surface.sendMidiEvent(144, 60, velocity);
                break;
            }
            case 40: {
                this.surface.sendMidiEvent(144, 72, velocity);
                break;
            }
            case 41: {
                this.surface.sendMidiEvent(144, 84, velocity);
                break;
            }
        }
        if (velocity == 0) {
            return;
        }
        if (note >= 52 && note < 84) {
            int n = note - 52;
            int row = n / 8;
            int col = n % 8;
            switch (col) {
                case 6: {
                    return;
                }
                case 7: {
                    if (row == 0) {
                        browser.selectNextResult();
                        break;
                    }
                    if (row == 1) {
                        for (int i = 0; i < 8; ++i) {
                            browser.selectNextResult();
                        }
                        break;
                    }
                    if (row == 2) {
                        for (int i = 0; i < 8; ++i) {
                            browser.selectPreviousResult();
                        }
                        break;
                    }
                    if (row != 3) break;
                    browser.selectPreviousResult();
                    break;
                }
                default: {
                    if (row == 0) {
                        browser.selectNextFilterItem(COLUMN_ORDER[col]);
                        break;
                    }
                    if (row == 1) {
                        for (int i = 0; i < 8; ++i) {
                            browser.selectNextFilterItem(COLUMN_ORDER[col]);
                        }
                        break;
                    }
                    if (row == 2) {
                        for (int i = 0; i < 8; ++i) {
                            browser.selectPreviousFilterItem(COLUMN_ORDER[col]);
                        }
                        break;
                    }
                    if (row != 3) break;
                    browser.selectPreviousFilterItem(COLUMN_ORDER[col]);
                }
            }
        }
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        return "BUTTON_STATE_OFF";
    }
}

