/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.application;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.utils.ButtonEvent;

public class OverdubCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    private final ITransport transport;

    public OverdubCommand(IModel model, S surface) {
        super(model, surface);
        this.transport = this.model.getTransport();
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        if (this.surface.isSelectPressed()) {
            this.transport.toggleWriteClipLauncherAutomation();
        } else {
            this.transport.toggleOverdub();
        }
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event == ButtonEvent.UP) {
            this.shiftedFunction();
        }
    }

    protected void shiftedFunction() {
        this.transport.toggleLauncherOverdub();
    }

    public boolean isActive() {
        if (this.surface.isSelectPressed()) {
            return this.transport.isWritingClipLauncherAutomation();
        }
        return this.surface.isShiftPressed() ? this.transport.isLauncherOverdub() : this.transport.isArrangerOverdub();
    }
}

