/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;
import de.mossgrabers.framework.view.sequencer.AbstractDrumView;
import java.util.Optional;

public class BrowserCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    private final ButtonID firstTrigger;
    private final ButtonID secondTrigger;

    public BrowserCommand(IModel model, S surface) {
        this(model, surface, ButtonID.SHIFT, ButtonID.SELECT);
    }

    public BrowserCommand(IModel model, S surface, ButtonID firstTrigger, ButtonID secondTrigger) {
        super(model, surface);
        this.firstTrigger = firstTrigger;
        this.secondTrigger = secondTrigger;
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        if (event != ButtonEvent.UP) {
            return;
        }
        if (this.secondTrigger != null) {
            if (this.surface.isPressed(this.firstTrigger)) {
                this.startBrowser(true, true);
            } else {
                this.startBrowser(this.surface.isPressed(this.secondTrigger), false);
            }
        } else if (this.surface.isPressed(this.firstTrigger)) {
            this.startBrowser(true, false);
        } else {
            this.startBrowser(false, false);
        }
    }

    public void startBrowser(boolean insertDevice, boolean beforeCurrent) {
        if (this.model.getBrowser().isActive()) {
            this.discardBrowser(this.getCommit());
            return;
        }
        this.activateBrowser(insertDevice, beforeCurrent);
    }

    private boolean activateBrowser(boolean insertDevice, boolean beforeCurrent) {
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        boolean hasCursorDevice = cursorDevice.doesExist();
        IBrowser browser = this.model.getBrowser();
        if (hasCursorDevice) {
            if (!insertDevice) {
                browser.replace(cursorDevice);
                return true;
            }
            if (Modes.isLayerMode((Modes)((Object)this.surface.getModeManager().getActiveID()))) {
                Optional layer = cursorDevice.getLayerBank().getSelectedItem();
                if (layer.isEmpty()) {
                    return false;
                }
                browser.addDevice((IChannel)layer.get());
                return true;
            }
            if (beforeCurrent) {
                browser.insertBeforeCursorDevice();
            } else {
                browser.insertAfterCursorDevice();
            }
            return true;
        }
        Optional channel = this.model.getCurrentTrackBank().getSelectedItem();
        if (channel.isPresent()) {
            browser.addDevice((IChannel)channel.get());
            return true;
        }
        IMasterTrack master = this.model.getMasterTrack();
        if (!master.isSelected()) {
            return false;
        }
        browser.addDevice(master);
        return true;
    }

    public void discardBrowser(boolean commit) {
        this.model.getBrowser().stopBrowsing(commit);
        if (!commit) {
            return;
        }
        ViewManager viewManager = this.surface.getViewManager();
        if (viewManager.isActive(new Views[]{Views.DRUM})) {
            ((AbstractDrumView)AbstractDrumView.class.cast(viewManager.get(Views.DRUM))).repositionBankPage();
        }
    }

    protected boolean getCommit() {
        return !this.surface.isShiftPressed();
    }
}

