/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.yaeltex.turn.mode;

import de.mossgrabers.controller.yaeltex.turn.YaeltexTurnConfiguration;
import de.mossgrabers.controller.yaeltex.turn.controller.YaeltexTurnColorManager;
import de.mossgrabers.controller.yaeltex.turn.controller.YaeltexTurnControlSurface;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.DeviceID;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.IDevice;
import de.mossgrabers.framework.daw.data.IEqualizerDevice;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IParameterPageBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.IParameterProvider;
import de.mossgrabers.framework.parameterprovider.device.BankParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.CombinedParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.FixedParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.PanParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.SendParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.VolumeParameterProvider;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class YaeltexTurnTrackMixMode
extends AbstractParameterMode<YaeltexTurnControlSurface, YaeltexTurnConfiguration, ITrack> {
    private final IEqualizerDevice eqDevice;
    protected final List<IParameterProvider> providers = new ArrayList<IParameterProvider>();

    public YaeltexTurnTrackMixMode(YaeltexTurnControlSurface surface, IModel model, List<ContinuousID> controls) {
        this("Track Mixer", surface, model, controls);
        this.providers.add(0, new BankParameterProvider(this.model.getCursorDevice().getParameterBank()));
        this.providers.add(0, new SendParameterProvider(model, 1, 0));
        this.providers.add(0, new SendParameterProvider(model, 0, 0));
        this.providers.add(0, new PanParameterProvider(model));
        this.setParameterProvider(new CombinedParameterProvider(this.providers));
    }

    protected YaeltexTurnTrackMixMode(String name, YaeltexTurnControlSurface surface, IModel model, List<ContinuousID> controls) {
        super(name, surface, model, true, model.getTrackBank(), controls);
        this.eqDevice = (IEqualizerDevice)model.getSpecificDevice(DeviceID.EQ);
        this.providers.add(new FixedParameterProvider(this.eqDevice.getTypeParameters()));
        this.providers.add(new FixedParameterProvider(this.eqDevice.getQParameters()));
        this.providers.add(new FixedParameterProvider(this.eqDevice.getFrequencyParameters()));
        this.providers.add(new FixedParameterProvider(this.eqDevice.getGainParameters()));
        this.providers.add(new VolumeParameterProvider(model));
        this.model.getTrackBank().addSelectionObserver(this::trackSelectionChanged);
    }

    @Override
    public void onActivate() {
        this.trackSelectionChanged(-1, true);
        super.onActivate();
    }

    @Override
    public int getKnobValue(int index) {
        int row = index / 8;
        int column = index % 8;
        ITrack track = (ITrack)this.model.getTrackBank().getItem(column);
        switch (row) {
            case 0: {
                return track.getPan();
            }
            case 1: {
                return ((ISend)track.getSendBank().getItem(0)).getValue();
            }
            case 2: {
                return ((ISend)track.getSendBank().getItem(1)).getValue();
            }
            case 3: {
                return ((IParameter)this.model.getCursorDevice().getParameterBank().getItem(column)).getValue();
            }
        }
        return 0;
    }

    @Override
    public int getKnobColor(int index) {
        int row = index / 8;
        int column = index % 8;
        ColorEx color = row < 3 ? ((ITrack)this.model.getTrackBank().getItem(column)).getColor() : ColorEx.WHITE;
        return YaeltexTurnColorManager.getIndexFor(color);
    }

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (((YaeltexTurnControlSurface)this.surface).isShiftPressed()) {
            this.onShiftButton(row, index);
            return;
        }
        ITrack track = (ITrack)this.model.getCurrentTrackBank().getItem(index);
        switch (row) {
            case 0: {
                IParameter crossfadeParameter = track.getCrossfadeParameter();
                double value = this.model.getValueChanger().toNormalizedValue(crossfadeParameter.getValue()) + 0.5;
                crossfadeParameter.setNormalizedValue(value > 1.1 ? 0.0 : value);
                break;
            }
            case 1: {
                if (((YaeltexTurnControlSurface)this.surface).isSelectPressed()) {
                    track.returnToArrangement();
                    break;
                }
                track.stop(((YaeltexTurnControlSurface)this.surface).isShiftPressed());
                break;
            }
            case 2: {
                track.toggleRecArm();
                break;
            }
            case 3: {
                if (((YaeltexTurnControlSurface)this.surface).isSelectPressed()) {
                    this.model.getProject().clearSolo();
                    break;
                }
                track.toggleSolo();
                break;
            }
            case 4: {
                if (((YaeltexTurnControlSurface)this.surface).isSelectPressed()) {
                    this.model.getProject().clearMute();
                    break;
                }
                track.toggleMute();
                break;
            }
            case 5: {
                track.selectOrExpandGroup();
                break;
            }
        }
    }

    protected void onShiftButton(int row, int index) {
        if (row == 0 || row == 1) {
            int deviceIndex = 2 * index + row;
            IDevice device = (IDevice)this.model.getCursorDevice().getDeviceBank().getItem(deviceIndex);
            if (device.doesExist()) {
                device.select();
                this.mvHelper.notifySelectedDevice();
            }
            return;
        }
        if (row == 2 || row == 3) {
            int paramPageIndex = 2 * index + row - 2;
            this.model.getCursorDevice().getParameterBank().getPageBank().selectPage(paramPageIndex);
            this.mvHelper.notifySelectedDeviceAndParameterPage();
            return;
        }
        if (row == 5) {
            ((YaeltexTurnControlSurface)this.surface).getDisplay().notify(AbstractConfiguration.getNewClipLengthValue(index));
            ((YaeltexTurnConfiguration)((YaeltexTurnControlSurface)this.surface).getConfiguration()).setNewClipLength(index);
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        if (((YaeltexTurnControlSurface)this.surface).isShiftPressed()) {
            return this.getButtonShiftColor(buttonID);
        }
        int color = 0;
        switch (buttonID) {
            case ROW1_1: 
            case ROW1_2: 
            case ROW1_3: 
            case ROW1_4: 
            case ROW1_5: 
            case ROW1_6: 
            case ROW1_7: 
            case ROW1_8: {
                ITrack track = this.getTrack(buttonID, ButtonID.ROW1_1);
                String crossfadeMode = track.getCrossfadeParameter().getDisplayedValue();
                if (!track.doesExist() || "AB".equals(crossfadeMode)) break;
                color = "B".equals(crossfadeMode) ? YaeltexTurnColorManager.BLUE : YaeltexTurnColorManager.CYAN;
                break;
            }
            case ROW2_1: 
            case ROW2_2: 
            case ROW2_3: 
            case ROW2_4: 
            case ROW2_5: 
            case ROW2_6: 
            case ROW2_7: 
            case ROW2_8: {
                if (!this.getTrack(buttonID, ButtonID.ROW2_1).doesExist()) break;
                color = ((YaeltexTurnControlSurface)this.surface).isPressed(buttonID) ? 127 : 12;
                break;
            }
            case ROW3_1: 
            case ROW3_2: 
            case ROW3_3: 
            case ROW3_4: 
            case ROW3_5: 
            case ROW3_6: 
            case ROW3_7: 
            case ROW3_8: {
                color = this.getTrack(buttonID, ButtonID.ROW3_1).isRecArm() ? 1 : 0;
                break;
            }
            case ROW4_1: 
            case ROW4_2: 
            case ROW4_3: 
            case ROW4_4: 
            case ROW4_5: 
            case ROW4_6: 
            case ROW4_7: 
            case ROW4_8: {
                color = this.getTrack(buttonID, ButtonID.ROW4_1).isSolo() ? YaeltexTurnColorManager.YELLOW : 0;
                break;
            }
            case ROW5_1: 
            case ROW5_2: 
            case ROW5_3: 
            case ROW5_4: 
            case ROW5_5: 
            case ROW5_6: 
            case ROW5_7: 
            case ROW5_8: {
                color = this.getTrack(buttonID, ButtonID.ROW5_1).isMute() ? 7 : 0;
                break;
            }
            case ROW6_1: 
            case ROW6_2: 
            case ROW6_3: 
            case ROW6_4: 
            case ROW6_5: 
            case ROW6_6: 
            case ROW6_7: 
            case ROW6_8: {
                color = this.getTrack(buttonID, ButtonID.ROW6_1).isSelected() ? YaeltexTurnColorManager.YELLOW : 127;
                break;
            }
        }
        return color;
    }

    protected int getButtonShiftColor(ButtonID buttonID) {
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        int deviceIndex = -1;
        int paramPageIndex = -1;
        switch (buttonID) {
            case ROW1_1: 
            case ROW1_2: 
            case ROW1_3: 
            case ROW1_4: 
            case ROW1_5: 
            case ROW1_6: 
            case ROW1_7: 
            case ROW1_8: {
                deviceIndex = 2 * (buttonID.ordinal() - ButtonID.ROW1_1.ordinal());
                break;
            }
            case ROW2_1: 
            case ROW2_2: 
            case ROW2_3: 
            case ROW2_4: 
            case ROW2_5: 
            case ROW2_6: 
            case ROW2_7: 
            case ROW2_8: {
                deviceIndex = 2 * (buttonID.ordinal() - ButtonID.ROW2_1.ordinal()) + 1;
                break;
            }
            case ROW3_1: 
            case ROW3_2: 
            case ROW3_3: 
            case ROW3_4: 
            case ROW3_5: 
            case ROW3_6: 
            case ROW3_7: 
            case ROW3_8: {
                paramPageIndex = 2 * (buttonID.ordinal() - ButtonID.ROW3_1.ordinal());
                break;
            }
            case ROW4_1: 
            case ROW4_2: 
            case ROW4_3: 
            case ROW4_4: 
            case ROW4_5: 
            case ROW4_6: 
            case ROW4_7: 
            case ROW4_8: {
                paramPageIndex = 2 * (buttonID.ordinal() - ButtonID.ROW4_1.ordinal()) + 1;
                break;
            }
            case ROW6_1: 
            case ROW6_2: 
            case ROW6_3: 
            case ROW6_4: 
            case ROW6_5: 
            case ROW6_6: 
            case ROW6_7: 
            case ROW6_8: {
                int index = buttonID.ordinal() - ButtonID.ROW6_1.ordinal();
                return ((YaeltexTurnConfiguration)((YaeltexTurnControlSurface)this.surface).getConfiguration()).getNewClipLength() == index ? YaeltexTurnColorManager.BLUE : 0;
            }
        }
        if (deviceIndex != -1) {
            IDevice device = (IDevice)cursorDevice.getDeviceBank().getItem(deviceIndex);
            if (!device.doesExist()) {
                return 0;
            }
            return deviceIndex == cursorDevice.getIndex() ? YaeltexTurnColorManager.CYAN : 127;
        }
        if (paramPageIndex != -1) {
            IParameterPageBank parameterPageBank = cursorDevice.getParameterBank().getPageBank();
            String paramPage = (String)parameterPageBank.getItem(paramPageIndex);
            if (paramPage == null || paramPage.isBlank()) {
                return 0;
            }
            return paramPageIndex == parameterPageBank.getSelectedItemIndex() ? YaeltexTurnColorManager.BLUE : 127;
        }
        return 0;
    }

    private void trackSelectionChanged(int index, boolean isSelected) {
        Optional selectedTrack;
        if (!isSelected || !this.isActive) {
            return;
        }
        if (!this.eqDevice.doesExist() && (selectedTrack = this.model.getCurrentTrackBank().getSelectedItem()).isPresent()) {
            ((ITrack)selectedTrack.get()).addEqualizerDevice();
        }
    }

    @Override
    public void selectPreviousItem() {
        this.bank.selectPreviousPage();
        this.mvHelper.notifyTrackRange();
    }

    @Override
    public void selectNextItem() {
        this.bank.selectNextPage();
        this.mvHelper.notifyTrackRange();
    }

    @Override
    public void selectPreviousItemPage() {
        if (((YaeltexTurnControlSurface)this.surface).isShiftPressed()) {
            ITrackBank trackBank = this.model.getTrackBank();
            for (int i = 0; i < 8; ++i) {
                ((ITrack)trackBank.getItem(i)).getSendBank().selectPreviousPage();
            }
            this.mvHelper.notifySelectedSends(((ITrack)trackBank.getItem(0)).getSendBank());
            return;
        }
        this.model.getSceneBank().selectPreviousPage();
        this.mvHelper.notifyScenePage();
    }

    @Override
    public void selectNextItemPage() {
        if (((YaeltexTurnControlSurface)this.surface).isShiftPressed()) {
            ITrackBank trackBank = this.model.getTrackBank();
            for (int i = 0; i < 8; ++i) {
                ((ITrack)trackBank.getItem(i)).getSendBank().selectNextPage();
            }
            this.mvHelper.notifySelectedSends(((ITrack)trackBank.getItem(0)).getSendBank());
            return;
        }
        this.model.getSceneBank().selectNextPage();
        this.mvHelper.notifyScenePage();
    }

    @Override
    public boolean hasPreviousItem() {
        return this.bank.canScrollPageBackwards();
    }

    @Override
    public boolean hasNextItem() {
        return this.bank.canScrollPageForwards();
    }

    @Override
    public boolean hasPreviousItemPage() {
        if (((YaeltexTurnControlSurface)this.surface).isShiftPressed()) {
            ITrackBank trackBank = this.model.getTrackBank();
            boolean canScroll = false;
            for (int i = 0; i < 8; ++i) {
                canScroll |= ((ITrack)trackBank.getItem(i)).getSendBank().canScrollPageBackwards();
            }
            return canScroll;
        }
        return this.model.getSceneBank().canScrollPageBackwards();
    }

    @Override
    public boolean hasNextItemPage() {
        if (((YaeltexTurnControlSurface)this.surface).isShiftPressed()) {
            ITrackBank trackBank = this.model.getTrackBank();
            boolean canScroll = false;
            for (int i = 0; i < 8; ++i) {
                canScroll |= ((ITrack)trackBank.getItem(i)).getSendBank().canScrollPageForwards();
            }
            return canScroll;
        }
        return this.model.getSceneBank().canScrollPageForwards();
    }

    private ITrack getTrack(ButtonID buttonID, ButtonID firstButtinInRow) {
        return (ITrack)this.model.getCurrentTrackBank().getItem(buttonID.ordinal() - firstButtinInRow.ordinal());
    }
}

