/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.slmkiii.mode.track;

import de.mossgrabers.controller.novation.slmkiii.controller.SLMkIIIControlSurface;
import de.mossgrabers.controller.novation.slmkiii.controller.SLMkIIIDisplay;
import de.mossgrabers.controller.novation.slmkiii.mode.track.AbstractTrackMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.parameterprovider.special.ResetParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.SendParameterProvider;
import de.mossgrabers.framework.utils.StringUtils;

public class SLMkIIISendMode
extends AbstractTrackMode {
    private final int sendIndex;

    public SLMkIIISendMode(int sendIndex, SLMkIIIControlSurface surface, IModel model) {
        super("Send", surface, model);
        this.sendIndex = sendIndex;
        SendParameterProvider parameterProvider = new SendParameterProvider(model, sendIndex, 0);
        this.setParameterProvider(parameterProvider);
        this.setParameterProvider(ButtonID.DELETE, new ResetParameterProvider(parameterProvider));
    }

    @Override
    public void updateDisplay() {
        SLMkIIIDisplay d = ((SLMkIIIControlSurface)this.surface).getDisplay();
        d.clear();
        d.setCell(0, 8, "Send " + (this.sendIndex + 1));
        ITrackBank tb = this.model.getCurrentTrackBank();
        for (int i = 0; i < 8; ++i) {
            ISend send;
            int color = 0;
            ITrack t = (ITrack)tb.getItem(i);
            if (t.doesExist() && (send = (ISend)t.getSendBank().getItem(this.sendIndex)).doesExist()) {
                d.setCell(0, i, send.getName(9)).setCell(1, i, send.getDisplayedValue(9));
                color = 13;
            }
            this.setColumnColors(d, i, t, color);
        }
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        d.setCell(1, 8, cursorTrack == null ? "" : StringUtils.fixASCII(cursorTrack.getName(9)));
        this.drawRow4();
        this.setButtonInfo(d);
        d.allDone();
    }

    @Override
    public int getModeColor() {
        return 13;
    }
}

